/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aws.outbound;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.handlers.AsyncHandler;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.integration.MessageTimeoutException;
import org.springframework.integration.aws.support.AwsRequestFailureException;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.handler.AbstractMessageProducingHandler;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.support.DefaultErrorMessageStrategy;
import org.springframework.integration.support.ErrorMessageStrategy;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;

public abstract class AbstractAwsMessageHandler<H>
extends AbstractMessageProducingHandler {
    protected static final long DEFAULT_SEND_TIMEOUT = 10000L;
    private AsyncHandler<? extends AmazonWebServiceRequest, ?> asyncHandler;
    private EvaluationContext evaluationContext;
    private boolean sync;
    private Expression sendTimeoutExpression = new ValueExpression((Object)10000L);
    private ErrorMessageStrategy errorMessageStrategy = new DefaultErrorMessageStrategy();
    private MessageChannel failureChannel;
    private String failureChannelName;
    private HeaderMapper<H> headerMapper;

    public void setAsyncHandler(AsyncHandler<? extends AmazonWebServiceRequest, ?> asyncHandler) {
        this.asyncHandler = asyncHandler;
    }

    protected AsyncHandler<? extends AmazonWebServiceRequest, ?> getAsyncHandler() {
        return this.asyncHandler;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    protected boolean isSync() {
        return this.sync;
    }

    public void setSendTimeout(long sendTimeout) {
        this.setSendTimeoutExpression((Expression)new ValueExpression((Object)sendTimeout));
    }

    public void setSendTimeoutExpressionString(String sendTimeoutExpression) {
        this.setSendTimeoutExpression(EXPRESSION_PARSER.parseExpression(sendTimeoutExpression));
    }

    public void setSendTimeoutExpression(Expression sendTimeoutExpression) {
        Assert.notNull((Object)sendTimeoutExpression, (String)"'sendTimeoutExpression' must not be null");
        this.sendTimeoutExpression = sendTimeoutExpression;
    }

    protected Expression getSendTimeoutExpression() {
        return this.sendTimeoutExpression;
    }

    public void setFailureChannel(MessageChannel failureChannel) {
        this.failureChannel = failureChannel;
    }

    public void setFailureChannelName(String failureChannelName) {
        this.failureChannelName = failureChannelName;
    }

    protected MessageChannel getFailureChannel() {
        if (this.failureChannel != null) {
            return this.failureChannel;
        }
        if (this.failureChannelName != null) {
            this.failureChannel = (MessageChannel)this.getChannelResolver().resolveDestination(this.failureChannelName);
            return this.failureChannel;
        }
        return null;
    }

    public void setErrorMessageStrategy(ErrorMessageStrategy errorMessageStrategy) {
        Assert.notNull((Object)errorMessageStrategy, (String)"'errorMessageStrategy' must not be null");
        this.errorMessageStrategy = errorMessageStrategy;
    }

    protected ErrorMessageStrategy getErrorMessageStrategy() {
        return this.errorMessageStrategy;
    }

    public void setHeaderMapper(HeaderMapper<H> headerMapper) {
        this.doSetHeaderMapper(headerMapper);
    }

    protected final void doSetHeaderMapper(HeaderMapper<H> headerMapper) {
        this.headerMapper = headerMapper;
    }

    protected HeaderMapper<H> getHeaderMapper() {
        return this.headerMapper;
    }

    protected EvaluationContext getEvaluationContext() {
        return this.evaluationContext;
    }

    protected void onInit() throws Exception {
        super.onInit();
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
    }

    protected void handleMessageInternal(Message<?> message) throws Exception {
        Future<?> resultFuture = this.handleMessageToAws(message);
        if (this.sync) {
            Long sendTimeout = (Long)this.sendTimeoutExpression.getValue(this.evaluationContext, message, Long.class);
            if (sendTimeout == null || sendTimeout < 0L) {
                resultFuture.get();
            } else {
                try {
                    resultFuture.get(sendTimeout, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException te) {
                    throw new MessageTimeoutException(message, "Timeout waiting for response from AmazonKinesis", (Throwable)te);
                }
            }
        }
    }

    protected <I extends AmazonWebServiceRequest, O> AsyncHandler<I, O> obtainAsyncHandler(final Message<?> message, final AmazonWebServiceRequest request) {
        return new AsyncHandler<I, O>(){

            public void onError(Exception ex) {
                if (AbstractAwsMessageHandler.this.getAsyncHandler() != null) {
                    AbstractAwsMessageHandler.this.getAsyncHandler().onError(ex);
                }
                if (AbstractAwsMessageHandler.this.getFailureChannel() != null) {
                    AbstractAwsMessageHandler.this.messagingTemplate.send((Object)AbstractAwsMessageHandler.this.getFailureChannel(), (Message)AbstractAwsMessageHandler.this.getErrorMessageStrategy().buildErrorMessage((Throwable)((Object)new AwsRequestFailureException(message, request, ex)), null));
                }
            }

            public void onSuccess(I request2, O result) {
                if (AbstractAwsMessageHandler.this.getAsyncHandler() != null) {
                    AbstractAwsMessageHandler.this.getAsyncHandler().onSuccess(request2, result);
                }
                if (AbstractAwsMessageHandler.this.getOutputChannel() != null) {
                    AbstractIntegrationMessageBuilder messageBuilder = AbstractAwsMessageHandler.this.getMessageBuilderFactory().fromMessage(message);
                    AbstractAwsMessageHandler.this.additionalOnSuccessHeaders((AbstractIntegrationMessageBuilder<?>)messageBuilder, (AmazonWebServiceRequest)request2, result);
                    messageBuilder.setHeaderIfAbsent("aws_serviceResult", result);
                    AbstractAwsMessageHandler.this.messagingTemplate.send((Object)AbstractAwsMessageHandler.this.getOutputChannel(), messageBuilder.build());
                }
            }
        };
    }

    protected abstract Future<?> handleMessageToAws(Message<?> var1) throws Exception;

    protected abstract void additionalOnSuccessHeaders(AbstractIntegrationMessageBuilder<?> var1, AmazonWebServiceRequest var2, Object var3);
}

