/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aws.outbound;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSAsync;
import com.amazonaws.services.sqs.model.MessageAttributeValue;
import com.amazonaws.services.sqs.model.SendMessageBatchRequest;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageResult;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import org.springframework.cloud.aws.core.env.ResourceIdResolver;
import org.springframework.cloud.aws.messaging.support.destination.DynamicQueueUrlDestinationResolver;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.aws.outbound.AbstractAwsMessageHandler;
import org.springframework.integration.aws.support.SqsHeaderMapper;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.GenericMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SqsMessageHandler
extends AbstractAwsMessageHandler<Map<String, MessageAttributeValue>> {
    private final AmazonSQSAsync amazonSqs;
    private final DestinationResolver<?> destinationResolver;
    private MessageConverter messageConverter;
    private Expression queueExpression;
    private Expression delayExpression;
    private Expression messageGroupIdExpression;
    private Expression messageDeduplicationIdExpression;

    public SqsMessageHandler(AmazonSQSAsync amazonSqs) {
        this(amazonSqs, (ResourceIdResolver)null);
    }

    public SqsMessageHandler(AmazonSQSAsync amazonSqs, ResourceIdResolver resourceIdResolver) {
        this(amazonSqs, (DestinationResolver<?>)new DynamicQueueUrlDestinationResolver((AmazonSQS)amazonSqs, resourceIdResolver));
    }

    public SqsMessageHandler(AmazonSQSAsync amazonSqs, DestinationResolver<?> destinationResolver) {
        Assert.notNull((Object)amazonSqs, (String)"'amazonSqs' must not be null");
        Assert.notNull(destinationResolver, (String)"'destinationResolver' must not be null");
        this.amazonSqs = amazonSqs;
        this.destinationResolver = destinationResolver;
        this.doSetHeaderMapper(new SqsHeaderMapper());
    }

    public void setQueue(String queue) {
        Assert.hasText((String)queue, (String)"'queue' must not be empty");
        this.setQueueExpression((Expression)new LiteralExpression(queue));
    }

    public void setQueueExpressionString(String queueExpression) {
        this.setQueueExpression(EXPRESSION_PARSER.parseExpression(queueExpression));
    }

    public void setQueueExpression(Expression queueExpression) {
        Assert.notNull((Object)queueExpression, (String)"'queueExpression' must not be null");
        this.queueExpression = queueExpression;
    }

    public void setDelay(int delaySeconds) {
        this.setDelayExpression((Expression)new ValueExpression((Object)delaySeconds));
    }

    public void setDelayExpressionString(String delayExpression) {
        this.setDelayExpression(EXPRESSION_PARSER.parseExpression(delayExpression));
    }

    public void setDelayExpression(Expression delayExpression) {
        Assert.notNull((Object)delayExpression, (String)"'delayExpression' must not be null");
        this.delayExpression = delayExpression;
    }

    public void setMessageGroupId(String messageGroupId) {
        this.setMessageGroupIdExpression((Expression)new LiteralExpression(messageGroupId));
    }

    public void setMessageGroupIdExpressionString(String groupIdExpression) {
        this.setMessageGroupIdExpression(EXPRESSION_PARSER.parseExpression(groupIdExpression));
    }

    public void setMessageGroupIdExpression(Expression messageGroupIdExpression) {
        Assert.notNull((Object)messageGroupIdExpression, (String)"'messageGroupIdExpression' must not be null");
        this.messageGroupIdExpression = messageGroupIdExpression;
    }

    public void setMessageDeduplicationId(String messageDeduplicationId) {
        this.setMessageDeduplicationIdExpression((Expression)new LiteralExpression(messageDeduplicationId));
    }

    public void setMessageDeduplicationIdExpressionString(String messageDeduplicationIdExpression) {
        this.setMessageDeduplicationIdExpression(EXPRESSION_PARSER.parseExpression(messageDeduplicationIdExpression));
    }

    public void setMessageDeduplicationIdExpression(Expression messageDeduplicationIdExpression) {
        Assert.notNull((Object)messageDeduplicationIdExpression, (String)"'messageDeduplicationIdExpression' must not be null");
        this.messageDeduplicationIdExpression = messageDeduplicationIdExpression;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    @Override
    protected void onInit() {
        super.onInit();
        if (this.messageConverter == null) {
            this.messageConverter = new GenericMessageConverter(this.getConversionService());
        }
    }

    @Override
    protected Future<?> handleMessageToAws(Message<?> message) {
        SendMessageRequest sendMessageRequest;
        Object payload = message.getPayload();
        if (payload instanceof SendMessageBatchRequest) {
            AsyncHandler asyncHandler = this.obtainAsyncHandler(message, (AmazonWebServiceRequest)((SendMessageBatchRequest)payload));
            return this.amazonSqs.sendMessageBatchAsync((SendMessageBatchRequest)payload, asyncHandler);
        }
        if (payload instanceof SendMessageRequest) {
            sendMessageRequest = (SendMessageRequest)payload;
        } else {
            HeaderMapper headerMapper;
            String queue = (String)message.getHeaders().get((Object)"aws_queue", String.class);
            if (!StringUtils.hasText((String)queue) && this.queueExpression != null) {
                queue = (String)this.queueExpression.getValue(this.getEvaluationContext(), message, String.class);
            }
            Assert.state((queue != null ? 1 : 0) != 0, (String)"'queue' must not be null for sending an SQS message. Consider configuring this handler with a 'queue'( or 'queueExpression') or supply an 'aws_queue' message header");
            String queueUrl = (String)this.destinationResolver.resolveDestination(queue);
            String messageBody = (String)this.messageConverter.fromMessage(message, String.class);
            sendMessageRequest = new SendMessageRequest(queueUrl, messageBody);
            if (this.delayExpression != null) {
                Integer delay = (Integer)this.delayExpression.getValue(this.getEvaluationContext(), message, Integer.class);
                sendMessageRequest.setDelaySeconds(delay);
            }
            if (this.messageGroupIdExpression != null) {
                String messageGroupId = (String)this.messageGroupIdExpression.getValue(this.getEvaluationContext(), message, String.class);
                sendMessageRequest.setMessageGroupId(messageGroupId);
            }
            if (this.messageDeduplicationIdExpression != null) {
                String messageDeduplicationId = (String)this.messageDeduplicationIdExpression.getValue(this.getEvaluationContext(), message, String.class);
                sendMessageRequest.setMessageDeduplicationId(messageDeduplicationId);
            }
            if ((headerMapper = this.getHeaderMapper()) != null) {
                this.mapHeaders(message, sendMessageRequest, headerMapper);
            }
        }
        AsyncHandler asyncHandler = this.obtainAsyncHandler(message, (AmazonWebServiceRequest)sendMessageRequest);
        return this.amazonSqs.sendMessageAsync(sendMessageRequest, asyncHandler);
    }

    private void mapHeaders(Message<?> message, SendMessageRequest sendMessageRequest, HeaderMapper<Map<String, MessageAttributeValue>> headerMapper) {
        HashMap messageAttributes = new HashMap();
        headerMapper.fromHeaders(message.getHeaders(), messageAttributes);
        if (!messageAttributes.isEmpty()) {
            sendMessageRequest.setMessageAttributes(messageAttributes);
        }
    }

    @Override
    protected void additionalOnSuccessHeaders(AbstractIntegrationMessageBuilder<?> messageBuilder, AmazonWebServiceRequest request, Object result) {
        if (result instanceof SendMessageResult) {
            SendMessageResult sendMessageResult = (SendMessageResult)result;
            messageBuilder.setHeaderIfAbsent("aws_messageId", (Object)sendMessageResult.getMessageId());
            messageBuilder.setHeaderIfAbsent("aws_sequenceNumber", (Object)sendMessageResult.getSequenceNumber());
        }
    }
}

