/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aws.inbound;

import com.amazonaws.services.sqs.AmazonSQSAsync;
import io.awspring.cloud.core.env.ResourceIdResolver;
import io.awspring.cloud.messaging.config.SimpleMessageListenerContainerFactory;
import io.awspring.cloud.messaging.listener.QueueMessageHandler;
import io.awspring.cloud.messaging.listener.SimpleMessageListenerContainer;
import io.awspring.cloud.messaging.listener.SqsMessageDeletionPolicy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.support.management.IntegrationManagedResource;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.messaging.handler.HandlerMethod;
import org.springframework.util.Assert;

@ManagedResource
@IntegrationManagedResource
public class SqsMessageDrivenChannelAdapter
extends MessageProducerSupport
implements DisposableBean {
    private final SimpleMessageListenerContainerFactory simpleMessageListenerContainerFactory = new SimpleMessageListenerContainerFactory();
    private final String[] queues;
    private SimpleMessageListenerContainer listenerContainer;
    private Long queueStopTimeout;
    private SqsMessageDeletionPolicy messageDeletionPolicy = SqsMessageDeletionPolicy.NO_REDRIVE;

    public SqsMessageDrivenChannelAdapter(AmazonSQSAsync amazonSqs, String ... queues) {
        Assert.noNullElements((Object[])queues, (String)"'queues' must not be empty");
        this.simpleMessageListenerContainerFactory.setAmazonSqs(amazonSqs);
        this.queues = Arrays.copyOf(queues, queues.length);
    }

    public void setTaskExecutor(AsyncTaskExecutor taskExecutor) {
        this.simpleMessageListenerContainerFactory.setTaskExecutor(taskExecutor);
    }

    public void setMaxNumberOfMessages(Integer maxNumberOfMessages) {
        this.simpleMessageListenerContainerFactory.setMaxNumberOfMessages(maxNumberOfMessages);
    }

    public void setVisibilityTimeout(Integer visibilityTimeout) {
        this.simpleMessageListenerContainerFactory.setVisibilityTimeout(visibilityTimeout);
    }

    public void setWaitTimeOut(Integer waitTimeOut) {
        this.simpleMessageListenerContainerFactory.setWaitTimeOut(waitTimeOut);
    }

    public void setResourceIdResolver(ResourceIdResolver resourceIdResolver) {
        this.simpleMessageListenerContainerFactory.setResourceIdResolver(resourceIdResolver);
    }

    public void setAutoStartup(boolean autoStartUp) {
        super.setAutoStartup(autoStartUp);
        this.simpleMessageListenerContainerFactory.setAutoStartup(autoStartUp);
    }

    public void setDestinationResolver(DestinationResolver<String> destinationResolver) {
        this.simpleMessageListenerContainerFactory.setDestinationResolver(destinationResolver);
    }

    public void setQueueStopTimeout(long queueStopTimeout) {
        this.queueStopTimeout = queueStopTimeout;
    }

    public void setMessageDeletionPolicy(SqsMessageDeletionPolicy messageDeletionPolicy) {
        Assert.notNull((Object)messageDeletionPolicy, (String)"'messageDeletionPolicy' must not be null.");
        this.messageDeletionPolicy = messageDeletionPolicy;
    }

    protected void onInit() {
        super.onInit();
        this.listenerContainer = this.simpleMessageListenerContainerFactory.createSimpleMessageListenerContainer();
        if (this.queueStopTimeout != null) {
            this.listenerContainer.setQueueStopTimeout(this.queueStopTimeout.longValue());
        }
        this.listenerContainer.setMessageHandler((QueueMessageHandler)new IntegrationQueueMessageHandler());
        try {
            this.listenerContainer.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new BeanCreationException("Cannot instantiate 'SimpleMessageListenerContainer'", (Throwable)e);
        }
    }

    public String getComponentType() {
        return "aws:sqs-message-driven-channel-adapter";
    }

    protected void doStart() {
        this.listenerContainer.start();
    }

    protected void doStop() {
        this.listenerContainer.stop();
    }

    @ManagedOperation
    public void stop(String logicalQueueName) {
        this.listenerContainer.stop(logicalQueueName);
    }

    @ManagedOperation
    public void start(String logicalQueueName) {
        this.listenerContainer.start(logicalQueueName);
    }

    @ManagedOperation
    public boolean isRunning(String logicalQueueName) {
        return this.listenerContainer.isRunning(logicalQueueName);
    }

    @ManagedAttribute
    public String[] getQueues() {
        return Arrays.copyOf(this.queues, this.queues.length);
    }

    public void destroy() {
        this.listenerContainer.destroy();
    }

    private class IntegrationQueueMessageHandler
    extends QueueMessageHandler {
        private IntegrationQueueMessageHandler() {
        }

        public Map<QueueMessageHandler.MappingInformation, HandlerMethod> getHandlerMethods() {
            HashSet<String> queues = new HashSet<String>(Arrays.asList(SqsMessageDrivenChannelAdapter.this.queues));
            QueueMessageHandler.MappingInformation mappingInformation = new QueueMessageHandler.MappingInformation(queues, SqsMessageDrivenChannelAdapter.this.messageDeletionPolicy);
            return Collections.singletonMap(mappingInformation, null);
        }

        protected void handleMessageInternal(Message<?> message, String lookupDestination) {
            MessageHeaders headers = message.getHeaders();
            Message messageToSend = SqsMessageDrivenChannelAdapter.this.getMessageBuilderFactory().fromMessage(message).removeHeaders(new String[]{"LogicalResourceId", "MessageId", "ReceiptHandle", "Acknowledgment"}).setHeader("aws_messageId", headers.get((Object)"MessageId")).setHeader("aws_receiptHandle", headers.get((Object)"ReceiptHandle")).setHeader("aws_receivedQueue", headers.get((Object)"LogicalResourceId")).setHeader("aws_acknowledgment", headers.get((Object)"Acknowledgment")).build();
            SqsMessageDrivenChannelAdapter.this.sendMessage(messageToSend);
        }
    }
}

