/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aws.outbound;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.kinesis.model.PutRecordRequest;
import com.amazonaws.services.kinesis.model.PutRecordResult;
import com.amazonaws.services.kinesis.model.PutRecordsRequest;
import com.amazonaws.services.kinesis.model.PutRecordsResult;
import com.amazonaws.services.kinesis.model.PutRecordsResultEntry;
import com.amazonaws.services.kinesis.producer.KinesisProducer;
import com.amazonaws.services.kinesis.producer.UserRecord;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.springframework.context.Lifecycle;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.aws.outbound.AbstractAwsMessageHandler;
import org.springframework.integration.aws.outbound.ConvertingFromMessageConverter;
import org.springframework.integration.aws.support.AwsRequestFailureException;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.integration.mapping.OutboundMessageMapper;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.support.MutableMessage;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class KplMessageHandler
extends AbstractAwsMessageHandler<Void>
implements Lifecycle {
    private final KinesisProducer kinesisProducer;
    private MessageConverter messageConverter = new ConvertingFromMessageConverter((Converter<Object, ?>)new SerializingConverter());
    private Expression streamExpression;
    private Expression partitionKeyExpression;
    private Expression explicitHashKeyExpression;
    private Expression sequenceNumberExpression;
    private OutboundMessageMapper<byte[]> embeddedHeadersMapper;
    private Duration flushDuration = Duration.ofMillis(0L);
    private volatile boolean running;
    private volatile ScheduledFuture<?> flushFuture;

    public KplMessageHandler(KinesisProducer kinesisProducer) {
        Assert.notNull((Object)kinesisProducer, (String)"'kinesisProducer' must not be null.");
        this.kinesisProducer = kinesisProducer;
    }

    @Deprecated
    public void setConverter(Converter<Object, byte[]> converter) {
        this.setMessageConverter(new ConvertingFromMessageConverter(converter));
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        Assert.notNull((Object)messageConverter, (String)"'messageConverter' must not be null.");
        this.messageConverter = messageConverter;
    }

    public void setStream(String stream) {
        this.setStreamExpression((Expression)new LiteralExpression(stream));
    }

    public void setStreamExpressionString(String streamExpression) {
        this.setStreamExpression(EXPRESSION_PARSER.parseExpression(streamExpression));
    }

    public void setStreamExpression(Expression streamExpression) {
        this.streamExpression = streamExpression;
    }

    public void setPartitionKey(String partitionKey) {
        this.setPartitionKeyExpression((Expression)new LiteralExpression(partitionKey));
    }

    public void setPartitionKeyExpressionString(String partitionKeyExpression) {
        this.setPartitionKeyExpression(EXPRESSION_PARSER.parseExpression(partitionKeyExpression));
    }

    public void setPartitionKeyExpression(Expression partitionKeyExpression) {
        this.partitionKeyExpression = partitionKeyExpression;
    }

    public void setExplicitHashKey(String explicitHashKey) {
        this.setExplicitHashKeyExpression((Expression)new LiteralExpression(explicitHashKey));
    }

    public void setExplicitHashKeyExpressionString(String explicitHashKeyExpression) {
        this.setExplicitHashKeyExpression(EXPRESSION_PARSER.parseExpression(explicitHashKeyExpression));
    }

    public void setExplicitHashKeyExpression(Expression explicitHashKeyExpression) {
        this.explicitHashKeyExpression = explicitHashKeyExpression;
    }

    public void setSequenceNumberExpressionString(String sequenceNumberExpression) {
        this.setSequenceNumberExpression(EXPRESSION_PARSER.parseExpression(sequenceNumberExpression));
    }

    public void setSequenceNumberExpression(Expression sequenceNumberExpression) {
        this.sequenceNumberExpression = sequenceNumberExpression;
    }

    public void setEmbeddedHeadersMapper(OutboundMessageMapper<byte[]> embeddedHeadersMapper) {
        this.embeddedHeadersMapper = embeddedHeadersMapper;
    }

    public void setFlushDuration(Duration flushDuration) {
        Assert.notNull((Object)flushDuration, (String)"'flushDuration' must not be null.");
        this.flushDuration = flushDuration;
    }

    @Override
    public void setHeaderMapper(HeaderMapper<Void> headerMapper) {
        throw new UnsupportedOperationException("Kinesis doesn't support headers.\nConsider to use 'OutboundMessageMapper<byte[]>' for embedding headers into the record data.");
    }

    public synchronized void start() {
        if (!this.running) {
            if (this.flushDuration.toMillis() > 0L) {
                this.flushFuture = this.getTaskScheduler().scheduleAtFixedRate(() -> ((KinesisProducer)this.kinesisProducer).flush(), this.flushDuration);
            }
            this.running = true;
        }
    }

    public synchronized void stop() {
        if (this.running) {
            this.running = false;
            if (this.flushFuture != null) {
                this.flushFuture.cancel(true);
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Future<?> handleMessageToAws(Message<?> message) {
        try {
            if (message.getPayload() instanceof PutRecordsRequest) {
                Future<PutRecordsResult> future = this.handlePutRecordsRequest(message, (PutRecordsRequest)message.getPayload());
                return future;
            }
            if (message.getPayload() instanceof UserRecord) {
                Future<?> future = this.handleUserRecord(message, this.buildPutRecordRequest(message), (UserRecord)message.getPayload());
                return future;
            }
            PutRecordRequest putRecordRequest = message.getPayload() instanceof PutRecordRequest ? (PutRecordRequest)message.getPayload() : this.buildPutRecordRequest(message);
            UserRecord userRecord = new UserRecord();
            userRecord.setExplicitHashKey(putRecordRequest.getExplicitHashKey());
            userRecord.setData(putRecordRequest.getData());
            userRecord.setPartitionKey(putRecordRequest.getPartitionKey());
            userRecord.setStreamName(putRecordRequest.getStreamName());
            Future<?> future = this.handleUserRecord(message, putRecordRequest, userRecord);
            return future;
        }
        finally {
            if (this.flushDuration.toMillis() <= 0L) {
                this.kinesisProducer.flush();
            }
        }
    }

    private Future<PutRecordsResult> handlePutRecordsRequest(Message<?> message, PutRecordsRequest putRecordsRequest) {
        PutRecordsResult putRecordsResult = new PutRecordsResult();
        SettableFuture putRecordsResultFuture = SettableFuture.create();
        AtomicInteger failedRecordsCount = new AtomicInteger();
        Flux.fromIterable((Iterable)putRecordsRequest.getRecords()).map(putRecordsRequestEntry -> {
            UserRecord userRecord = new UserRecord();
            userRecord.setExplicitHashKey(putRecordsRequestEntry.getExplicitHashKey());
            userRecord.setData(putRecordsRequestEntry.getData());
            userRecord.setPartitionKey(putRecordsRequestEntry.getPartitionKey());
            userRecord.setStreamName(putRecordsRequest.getStreamName());
            return userRecord;
        }).concatMap(userRecord -> Mono.fromFuture(KplMessageHandler.listenableFutureToCompletableFuture(this.kinesisProducer.addUserRecord(userRecord)))).map(userRecordResult -> {
            PutRecordsResultEntry putRecordsResultEntry = new PutRecordsResultEntry().withSequenceNumber(userRecordResult.getSequenceNumber()).withShardId(userRecordResult.getShardId());
            if (!userRecordResult.isSuccessful()) {
                failedRecordsCount.incrementAndGet();
                userRecordResult.getAttempts().stream().reduce((left, right) -> right).ifPresent(attempt -> putRecordsResultEntry.withErrorMessage(attempt.getErrorMessage()).withErrorCode(attempt.getErrorCode()));
            }
            return putRecordsResultEntry;
        }).collectList().map(putRecordsResultList -> putRecordsResult.withRecords((Collection)putRecordsResultList).withFailedRecordCount(Integer.valueOf(failedRecordsCount.get()))).subscribe(arg_0 -> ((SettableFuture)putRecordsResultFuture).set(arg_0), arg_0 -> ((SettableFuture)putRecordsResultFuture).setException(arg_0));
        this.applyCallbackForAsyncHandler(message, (AmazonWebServiceRequest)putRecordsRequest, (ListenableFuture)putRecordsResultFuture);
        return putRecordsResultFuture;
    }

    private Future<?> handleUserRecord(Message<?> message, PutRecordRequest putRecordRequest, UserRecord userRecord) {
        ListenableFuture recordResult = this.kinesisProducer.addUserRecord(userRecord);
        this.applyCallbackForAsyncHandler(message, (AmazonWebServiceRequest)putRecordRequest, recordResult);
        return recordResult;
    }

    private <R> void applyCallbackForAsyncHandler(final Message<?> message, final AmazonWebServiceRequest serviceRequest, ListenableFuture<R> result) {
        final AsyncHandler asyncHandler = this.obtainAsyncHandler(message, serviceRequest);
        FutureCallback callback = new FutureCallback<R>(){

            public void onFailure(Throwable ex) {
                asyncHandler.onError((Exception)(ex instanceof Exception ? (Exception)ex : new AwsRequestFailureException(message, serviceRequest, ex)));
            }

            public void onSuccess(R result) {
                asyncHandler.onSuccess(serviceRequest, result);
            }
        };
        Futures.addCallback(result, (FutureCallback)callback, (Executor)MoreExecutors.directExecutor());
    }

    private PutRecordRequest buildPutRecordRequest(Message<?> message) {
        byte[] bytes;
        MessageHeaders messageHeaders = message.getHeaders();
        String stream = (String)messageHeaders.get((Object)"aws_stream", String.class);
        if (!StringUtils.hasText((String)stream) && this.streamExpression != null) {
            stream = (String)this.streamExpression.getValue(this.getEvaluationContext(), message, String.class);
        }
        Assert.state((stream != null ? 1 : 0) != 0, (String)"'stream' must not be null for sending a Kinesis record. Consider configuring this handler with a 'stream'( or 'streamExpression') or supply an 'aws_stream' message header.");
        String partitionKey = (String)messageHeaders.get((Object)"aws_partitionKey", String.class);
        if (!StringUtils.hasText((String)partitionKey) && this.partitionKeyExpression != null) {
            partitionKey = (String)this.partitionKeyExpression.getValue(this.getEvaluationContext(), message, String.class);
        }
        Assert.state((partitionKey != null ? 1 : 0) != 0, (String)"'partitionKey' must not be null for sending a Kinesis record. Consider configuring this handler with a 'partitionKey'( or 'partitionKeyExpression') or supply an 'aws_partitionKey' message header.");
        String explicitHashKey = this.explicitHashKeyExpression != null ? (String)this.explicitHashKeyExpression.getValue(this.getEvaluationContext(), message, String.class) : null;
        String sequenceNumber = (String)messageHeaders.get((Object)"aws_sequenceNumber", String.class);
        if (!StringUtils.hasText((String)sequenceNumber) && this.sequenceNumberExpression != null) {
            sequenceNumber = (String)this.sequenceNumberExpression.getValue(this.getEvaluationContext(), message, String.class);
        }
        Object payload = message.getPayload();
        ByteBuffer data = null;
        MutableMessage messageToEmbed = null;
        if (payload instanceof ByteBuffer) {
            data = (ByteBuffer)payload;
            if (this.embeddedHeadersMapper != null) {
                messageToEmbed = new MutableMessage((Object)data.array(), (Map)messageHeaders);
            }
        } else {
            bytes = (byte[])(payload instanceof byte[] ? payload : this.messageConverter.fromMessage(message, byte[].class));
            Assert.notNull((Object)bytes, (String)"payload cannot be null");
            if (this.embeddedHeadersMapper != null) {
                messageToEmbed = new MutableMessage((Object)bytes, (Map)messageHeaders);
            } else {
                data = ByteBuffer.wrap(bytes);
            }
        }
        if (messageToEmbed != null) {
            try {
                bytes = (byte[])this.embeddedHeadersMapper.fromMessage((Message)messageToEmbed);
                Assert.notNull((Object)bytes, (String)"payload cannot be null");
                data = ByteBuffer.wrap(bytes);
            }
            catch (Exception ex) {
                throw new MessageConversionException(message, "Cannot embedded headers to payload", (Throwable)ex);
            }
        }
        return new PutRecordRequest().withStreamName(stream).withPartitionKey(partitionKey).withExplicitHashKey(explicitHashKey).withSequenceNumberForOrdering(sequenceNumber).withData(data);
    }

    @Override
    protected void additionalOnSuccessHeaders(AbstractIntegrationMessageBuilder<?> messageBuilder, AmazonWebServiceRequest request, Object result) {
        if (result instanceof PutRecordResult) {
            messageBuilder.setHeader("aws_shard", (Object)((PutRecordResult)result).getShardId()).setHeader("aws_sequenceNumber", (Object)((PutRecordResult)result).getSequenceNumber());
        }
    }

    private static <T> CompletableFuture<T> listenableFutureToCompletableFuture(final ListenableFuture<T> listenableFuture) {
        final CompletableFuture completable = new CompletableFuture<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                boolean result = listenableFuture.cancel(mayInterruptIfRunning);
                super.cancel(mayInterruptIfRunning);
                return result;
            }
        };
        Futures.addCallback(listenableFuture, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(@Nullable T result) {
                completable.complete(result);
            }

            public void onFailure(Throwable ex) {
                completable.completeExceptionally(ex);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return completable;
    }
}

