/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aws.support;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.IOException;
import org.springframework.integration.aws.support.S3SessionFactory;
import org.springframework.integration.file.remote.ClientCallback;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.file.remote.session.SessionFactory;

public class S3RemoteFileTemplate
extends RemoteFileTemplate<S3ObjectSummary> {
    public S3RemoteFileTemplate() {
        this(new S3SessionFactory());
    }

    public S3RemoteFileTemplate(AmazonS3 amazonS3) {
        this(new S3SessionFactory(amazonS3));
    }

    public S3RemoteFileTemplate(SessionFactory<S3ObjectSummary> sessionFactory) {
        super(sessionFactory);
    }

    public <T, C> T executeWithClient(ClientCallback<C, T> callback) {
        return (T)callback.doWithClient(this.sessionFactory.getSession().getClientInstance());
    }

    public boolean exists(String path) {
        try {
            return this.sessionFactory.getSession().exists(path);
        }
        catch (IOException e) {
            throw new AmazonS3Exception("Failed to check the path " + path, (Exception)e);
        }
    }
}

