/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aws.outbound;

import io.awspring.cloud.sns.core.CachingTopicArnResolver;
import io.awspring.cloud.sns.core.TopicArnResolver;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.springframework.expression.Expression;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.support.StandardTypeLocator;
import org.springframework.integration.aws.outbound.AbstractAwsMessageHandler;
import org.springframework.integration.aws.support.SnsAsyncTopicArnResolver;
import org.springframework.integration.aws.support.SnsBodyBuilder;
import org.springframework.integration.aws.support.SnsHeaderMapper;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import software.amazon.awssdk.awscore.AwsRequest;
import software.amazon.awssdk.awscore.AwsResponse;
import software.amazon.awssdk.services.sns.SnsAsyncClient;
import software.amazon.awssdk.services.sns.model.MessageAttributeValue;
import software.amazon.awssdk.services.sns.model.PublishRequest;
import software.amazon.awssdk.services.sns.model.PublishResponse;

public class SnsMessageHandler
extends AbstractAwsMessageHandler<Map<String, MessageAttributeValue>> {
    private final SnsAsyncClient amazonSns;
    private Expression topicArnExpression;
    private TopicArnResolver topicArnResolver;
    private Expression subjectExpression;
    private Expression messageGroupIdExpression;
    private Expression messageDeduplicationIdExpression;
    private Expression bodyExpression;

    public SnsMessageHandler(SnsAsyncClient amazonSns) {
        Assert.notNull((Object)amazonSns, (String)"amazonSns must not be null.");
        this.amazonSns = amazonSns;
        this.topicArnResolver = new CachingTopicArnResolver((TopicArnResolver)new SnsAsyncTopicArnResolver(this.amazonSns));
        this.doSetHeaderMapper(new SnsHeaderMapper());
    }

    public void setTopicArn(String topicArn) {
        Assert.hasText((String)topicArn, (String)"topicArn must not be empty.");
        this.topicArnExpression = new LiteralExpression(topicArn);
    }

    public void setTopicArnExpression(Expression topicArnExpression) {
        Assert.notNull((Object)topicArnExpression, (String)"topicArnExpression must not be null.");
        this.topicArnExpression = topicArnExpression;
    }

    public void setTopicArnResolver(TopicArnResolver topicArnResolver) {
        Assert.notNull((Object)topicArnResolver, (String)"'topicArnResolver' must not be null.");
        this.topicArnResolver = topicArnResolver;
    }

    public void setSubject(String subject) {
        Assert.hasText((String)subject, (String)"subject must not be empty.");
        this.subjectExpression = new LiteralExpression(subject);
    }

    public void setSubjectExpression(Expression subjectExpression) {
        Assert.notNull((Object)subjectExpression, (String)"subjectExpression must not be null.");
        this.subjectExpression = subjectExpression;
    }

    public void setMessageGroupId(String messageGroupId) {
        Assert.hasText((String)messageGroupId, (String)"messageGroupId must not be empty.");
        this.messageGroupIdExpression = new LiteralExpression(messageGroupId);
    }

    public void setMessageGroupIdExpression(Expression messageGroupIdExpression) {
        Assert.notNull((Object)messageGroupIdExpression, (String)"messageGroupIdExpression must not be null.");
        this.messageGroupIdExpression = messageGroupIdExpression;
    }

    public void setMessageDeduplicationIdExpression(Expression messageDeduplicationIdExpression) {
        Assert.notNull((Object)messageDeduplicationIdExpression, (String)"messageDeduplicationIdExpression must not be null.");
        this.messageDeduplicationIdExpression = messageDeduplicationIdExpression;
    }

    public void setBodyExpression(Expression bodyExpression) {
        Assert.notNull((Object)bodyExpression, (String)"bodyExpression must not be null.");
        this.bodyExpression = bodyExpression;
    }

    @Override
    protected void onInit() {
        super.onInit();
        TypeLocator typeLocator = this.getEvaluationContext().getTypeLocator();
        if (typeLocator instanceof StandardTypeLocator) {
            ((StandardTypeLocator)typeLocator).registerImport("org.springframework.integration.aws.support");
        }
    }

    @Override
    protected AwsRequest messageToAwsRequest(Message<?> message) {
        Object payload = message.getPayload();
        if (payload instanceof PublishRequest) {
            return (PublishRequest)payload;
        }
        Assert.state((this.topicArnExpression != null ? 1 : 0) != 0, (String)"'topicArn' or 'topicArnExpression' must be specified.");
        PublishRequest.Builder publishRequest = PublishRequest.builder();
        String topic = (String)this.topicArnExpression.getValue(this.getEvaluationContext(), message, String.class);
        String topicArn = this.topicArnResolver.resolveTopicArn(topic).toString();
        publishRequest.topicArn(topicArn);
        if (this.subjectExpression != null) {
            String subject = (String)this.subjectExpression.getValue(this.getEvaluationContext(), message, String.class);
            publishRequest.subject(subject);
        }
        if (topicArn.endsWith(".fifo")) {
            String messageGroupId = null;
            if (this.messageGroupIdExpression != null) {
                messageGroupId = (String)this.messageGroupIdExpression.getValue(this.getEvaluationContext(), message, String.class);
            }
            Assert.notNull(messageGroupId, () -> "The 'messageGroupIdExpression' [" + this.messageGroupIdExpression + "] must not evaluate to null. The failed request message is " + message);
            publishRequest.messageGroupId(messageGroupId);
            String messageDeduplicationId = null;
            if (this.messageDeduplicationIdExpression != null) {
                messageDeduplicationId = (String)this.messageDeduplicationIdExpression.getValue(this.getEvaluationContext(), message, String.class);
            }
            Assert.notNull(messageDeduplicationId, () -> "The 'messageDeduplicationIdExpression' [" + this.messageDeduplicationIdExpression + "] must not evaluate to null. The failed request message is " + message);
            publishRequest.messageDeduplicationId(messageDeduplicationId);
        } else if (this.messageGroupIdExpression != null || this.messageDeduplicationIdExpression != null) {
            this.logger.info((CharSequence)"The 'messageGroupIdExpression' and 'messageDeduplicationIdExpression' properties are ignored for non-FIFO topics.");
        }
        Object snsMessage = message.getPayload();
        if (this.bodyExpression != null) {
            snsMessage = this.bodyExpression.getValue(this.getEvaluationContext(), message);
        }
        if (snsMessage instanceof SnsBodyBuilder) {
            publishRequest.messageStructure("json").message(((SnsBodyBuilder)snsMessage).build());
        } else {
            publishRequest.message((String)this.getConversionService().convert(snsMessage, String.class));
        }
        HeaderMapper headerMapper = this.getHeaderMapper();
        if (headerMapper != null) {
            this.mapHeaders(message, publishRequest, headerMapper);
        }
        return (AwsRequest)publishRequest.build();
    }

    private void mapHeaders(Message<?> message, PublishRequest.Builder publishRequest, HeaderMapper<Map<String, MessageAttributeValue>> headerMapper) {
        HashMap messageAttributes = new HashMap();
        headerMapper.fromHeaders(message.getHeaders(), messageAttributes);
        if (!messageAttributes.isEmpty()) {
            publishRequest.messageAttributes(messageAttributes);
        }
    }

    @Override
    protected CompletableFuture<? extends AwsResponse> handleMessageToAws(Message<?> message, AwsRequest request) {
        return this.amazonSns.publish((PublishRequest)request);
    }

    @Override
    protected Map<String, ?> additionalOnSuccessHeaders(AwsRequest request, AwsResponse response) {
        return Map.of("aws_topic", ((PublishRequest)request).topicArn(), "aws_messageId", ((PublishResponse)response).messageId());
    }
}

