/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aws.outbound;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CompletionException;
import java.util.function.BiConsumer;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.util.Assert;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.internal.util.Mimetype;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.transfer.s3.S3TransferManager;
import software.amazon.awssdk.transfer.s3.model.CopyRequest;
import software.amazon.awssdk.transfer.s3.model.DownloadDirectoryRequest;
import software.amazon.awssdk.transfer.s3.model.DownloadFileRequest;
import software.amazon.awssdk.transfer.s3.model.Transfer;
import software.amazon.awssdk.transfer.s3.model.UploadDirectoryRequest;
import software.amazon.awssdk.transfer.s3.model.UploadRequest;
import software.amazon.awssdk.transfer.s3.progress.TransferListener;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.Md5Utils;

public class S3MessageHandler
extends AbstractReplyProducingMessageHandler {
    private final S3TransferManager transferManager;
    private final boolean produceReply;
    private final Expression bucketExpression;
    private EvaluationContext evaluationContext;
    private Expression keyExpression;
    private Expression destinationBucketExpression;
    private Expression destinationKeyExpression;
    private Expression commandExpression = new ValueExpression((Object)Command.UPLOAD);
    private BiConsumer<PutObjectRequest.Builder, Message<?>> uploadMetadataProvider = (builder, message) -> {};

    public S3MessageHandler(S3AsyncClient amazonS3, String bucket) {
        this(amazonS3, bucket, false);
    }

    public S3MessageHandler(S3AsyncClient amazonS3, Expression bucketExpression) {
        this(amazonS3, bucketExpression, false);
    }

    public S3MessageHandler(S3AsyncClient amazonS3, String bucket, boolean produceReply) {
        this(amazonS3, (Expression)new LiteralExpression(bucket), produceReply);
        Assert.notNull((Object)bucket, (String)"'bucket' must not be null");
    }

    public S3MessageHandler(S3AsyncClient amazonS3, Expression bucketExpression, boolean produceReply) {
        this(S3TransferManager.builder().s3Client(amazonS3).build(), bucketExpression, produceReply);
        Assert.notNull((Object)amazonS3, (String)"'amazonS3' must not be null");
    }

    public S3MessageHandler(S3TransferManager transferManager, String bucket) {
        this(transferManager, bucket, false);
    }

    public S3MessageHandler(S3TransferManager transferManager, Expression bucketExpression) {
        this(transferManager, bucketExpression, false);
    }

    public S3MessageHandler(S3TransferManager transferManager, String bucket, boolean produceReply) {
        this(transferManager, (Expression)new LiteralExpression(bucket), produceReply);
        Assert.notNull((Object)bucket, (String)"'bucket' must not be null");
    }

    public S3MessageHandler(S3TransferManager transferManager, Expression bucketExpression, boolean produceReply) {
        Assert.notNull((Object)transferManager, (String)"'transferManager' must not be null");
        Assert.notNull((Object)bucketExpression, (String)"'bucketExpression' must not be null");
        this.transferManager = transferManager;
        this.bucketExpression = bucketExpression;
        this.produceReply = produceReply;
    }

    public void setKeyExpression(Expression keyExpression) {
        this.keyExpression = keyExpression;
    }

    public void setCommand(Command command) {
        Assert.notNull((Object)((Object)command), (String)"'command' must not be null");
        this.setCommandExpression((Expression)new ValueExpression((Object)command));
    }

    public void setCommandExpression(Expression commandExpression) {
        Assert.notNull((Object)commandExpression, (String)"'commandExpression' must not be null");
        this.commandExpression = commandExpression;
    }

    public void setDestinationBucketExpression(Expression destinationBucketExpression) {
        this.destinationBucketExpression = destinationBucketExpression;
    }

    public void setDestinationKeyExpression(Expression destinationKeyExpression) {
        this.destinationKeyExpression = destinationKeyExpression;
    }

    public void setUploadMetadataProvider(BiConsumer<PutObjectRequest.Builder, Message<?>> uploadMetadataProvider) {
        Assert.notNull(uploadMetadataProvider, (String)"'uploadMetadataProvider' must not be null");
        this.uploadMetadataProvider = uploadMetadataProvider;
    }

    protected void doInit() {
        Assert.notNull((Object)this.bucketExpression, (String)"The 'bucketExpression' must not be null");
        super.doInit();
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        Transfer transfer;
        Command command = (Command)((Object)this.commandExpression.getValue(this.evaluationContext, requestMessage, Command.class));
        Assert.state((command != null ? 1 : 0) != 0, () -> "'commandExpression' [" + this.commandExpression.getExpressionString() + "] cannot evaluate to null.");
        TransferListener transferListener = (TransferListener)requestMessage.getHeaders().get((Object)"aws_transferListener", TransferListener.class);
        switch (command) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case UPLOAD: {
                Transfer transfer2 = this.upload(requestMessage, transferListener);
                break;
            }
            case DOWNLOAD: {
                Transfer transfer2 = this.download(requestMessage, transferListener);
                break;
            }
            case COPY: {
                Transfer transfer2 = transfer = this.copy(requestMessage, transferListener);
            }
        }
        if (this.produceReply) {
            return transfer;
        }
        try {
            transfer.completionFuture().join();
        }
        catch (CompletionException ex) {
            throw IntegrationUtils.wrapInHandlingExceptionIfNecessary(requestMessage, () -> "Failed to transfer file", (Throwable)ex.getCause());
        }
        return null;
    }

    private Transfer upload(Message<?> requestMessage, @Nullable TransferListener transferListener) {
        AsyncRequestBody requestBody;
        PutObjectRequest.Builder putObjectRequestBuilder;
        String key;
        block19: {
            File fileToUpload;
            Object payload = requestMessage.getPayload();
            String bucketName = this.obtainBucket(requestMessage);
            key = null;
            if (this.keyExpression != null) {
                key = (String)this.keyExpression.getValue(this.evaluationContext, requestMessage, String.class);
            } else if (payload instanceof File) {
                fileToUpload = (File)payload;
                key = fileToUpload.getName();
            }
            if (payload instanceof File && (fileToUpload = (File)payload).isDirectory()) {
                UploadDirectoryRequest.Builder uploadDirectoryRequest = UploadDirectoryRequest.builder().bucket(bucketName).source(fileToUpload.toPath()).s3Prefix(key);
                if (transferListener != null) {
                    uploadDirectoryRequest.uploadFileRequestTransformer(fileUpload -> fileUpload.addTransferListener(transferListener));
                }
                return this.transferManager.uploadDirectory(uploadDirectoryRequest.build());
            }
            putObjectRequestBuilder = ((PutObjectRequest.Builder)PutObjectRequest.builder().applyMutation(builder -> this.uploadMetadataProvider.accept((PutObjectRequest.Builder)builder, requestMessage))).bucket(bucketName).key(key);
            PutObjectRequest putObjectRequest = (PutObjectRequest)putObjectRequestBuilder.build();
            try {
                if (payload instanceof InputStream) {
                    InputStream inputStream = (InputStream)payload;
                    byte[] body = IoUtils.toByteArray((InputStream)inputStream);
                    if (putObjectRequest.contentMD5() == null) {
                        putObjectRequestBuilder.contentMD5(Md5Utils.md5AsBase64((byte[])body));
                        inputStream.reset();
                    }
                    requestBody = AsyncRequestBody.fromBytes((byte[])body);
                    break block19;
                }
                if (payload instanceof File) {
                    File fileToUpload2 = (File)payload;
                    if (putObjectRequest.contentMD5() == null) {
                        putObjectRequestBuilder.contentMD5(Md5Utils.md5AsBase64((File)fileToUpload2));
                    }
                    if (putObjectRequest.contentLength() == null) {
                        putObjectRequestBuilder.contentLength(Long.valueOf(fileToUpload2.length()));
                    }
                    if (putObjectRequest.contentType() == null) {
                        putObjectRequestBuilder.contentType(Mimetype.getInstance().getMimetype(fileToUpload2));
                    }
                    requestBody = AsyncRequestBody.fromBytes((byte[])FileUtils.readFileToByteArray((File)fileToUpload2));
                    break block19;
                }
                if (payload instanceof byte[]) {
                    byte[] payloadBytes = (byte[])payload;
                    if (putObjectRequest.contentMD5() == null) {
                        putObjectRequestBuilder.contentMD5(Md5Utils.md5AsBase64((byte[])payloadBytes));
                    }
                    if (putObjectRequest.contentLength() == null) {
                        putObjectRequestBuilder.contentLength(Long.valueOf(payloadBytes.length));
                    }
                    requestBody = AsyncRequestBody.fromBytes((byte[])payloadBytes);
                    break block19;
                }
                throw new IllegalArgumentException("Unsupported payload type: [" + payload.getClass() + "]. The only supported payloads for the upload request are java.io.File, java.io.InputStream, byte[] and PutObjectRequest.");
            }
            catch (IOException e) {
                throw new MessageHandlingException(requestMessage, (Throwable)e);
            }
        }
        if (key == null) {
            if (this.keyExpression != null) {
                throw new IllegalStateException("The 'keyExpression' [" + this.keyExpression.getExpressionString() + "] must not evaluate to null. Root object is: " + requestMessage);
            }
            throw new IllegalStateException("Specify a 'keyExpression' for non-java.io.File payloads");
        }
        UploadRequest.Builder uploadRequest = UploadRequest.builder().putObjectRequest((PutObjectRequest)putObjectRequestBuilder.build()).requestBody(requestBody);
        if (transferListener != null) {
            uploadRequest.addTransferListener(transferListener);
        }
        return this.transferManager.upload(uploadRequest.build());
    }

    private Transfer download(Message<?> requestMessage, TransferListener transferListener) {
        String key;
        Object payload = requestMessage.getPayload();
        Assert.state((boolean)(payload instanceof File), () -> "For the 'DOWNLOAD' operation the 'payload' must be of 'java.io.File' type, but gotten: [" + payload.getClass() + "]");
        File targetFile = (File)payload;
        String bucket = this.obtainBucket(requestMessage);
        String string = key = this.keyExpression != null ? (String)this.keyExpression.getValue(this.evaluationContext, requestMessage, String.class) : null;
        if (targetFile.isDirectory()) {
            DownloadDirectoryRequest.Builder downloadDirectoryRequest = DownloadDirectoryRequest.builder().bucket(bucket).destination(targetFile.toPath()).listObjectsV2RequestTransformer(filter -> filter.prefix(key));
            if (transferListener != null) {
                downloadDirectoryRequest.downloadFileRequestTransformer(fileDownload -> fileDownload.addTransferListener(transferListener));
            }
            return this.transferManager.downloadDirectory((DownloadDirectoryRequest)downloadDirectoryRequest.build());
        }
        DownloadFileRequest.Builder downloadFileRequest = DownloadFileRequest.builder().destination(targetFile).getObjectRequest(request -> request.bucket(bucket).key(key != null ? key : targetFile.getName()));
        if (transferListener != null) {
            downloadFileRequest.addTransferListener(transferListener);
        }
        return this.transferManager.downloadFile((DownloadFileRequest)downloadFileRequest.build());
    }

    private Transfer copy(Message<?> requestMessage, TransferListener transferListener) {
        String sourceBucketName = this.obtainBucket(requestMessage);
        String sourceKey = null;
        if (this.keyExpression != null) {
            sourceKey = (String)this.keyExpression.getValue(this.evaluationContext, requestMessage, String.class);
        }
        Assert.state((sourceKey != null ? 1 : 0) != 0, () -> "The 'keyExpression' must not be null for 'copy' operation and 'keyExpression' can't evaluate to null. Root object is: " + requestMessage);
        String destinationBucketName = null;
        if (this.destinationBucketExpression != null) {
            destinationBucketName = (String)this.destinationBucketExpression.getValue(this.evaluationContext, requestMessage, String.class);
        }
        Assert.state((destinationBucketName != null ? 1 : 0) != 0, () -> "The 'destinationBucketExpression' must not be null for 'copy' operation and can't evaluate to null. Root object is: " + requestMessage);
        String destinationKey = null;
        if (this.destinationKeyExpression != null) {
            destinationKey = (String)this.destinationKeyExpression.getValue(this.evaluationContext, requestMessage, String.class);
        }
        Assert.state((destinationKey != null ? 1 : 0) != 0, () -> "The 'destinationKeyExpression' must not be null for 'copy' operation and can't evaluate to null. Root object is: " + requestMessage);
        CopyObjectRequest.Builder copyObjectRequest = CopyObjectRequest.builder().sourceBucket(sourceBucketName).sourceKey(sourceKey).destinationBucket(destinationBucketName).destinationKey(destinationKey);
        CopyRequest.Builder copyRequest = CopyRequest.builder().copyObjectRequest((CopyObjectRequest)copyObjectRequest.build());
        if (transferListener != null) {
            copyRequest.addTransferListener(transferListener);
        }
        return this.transferManager.copy(copyRequest.build());
    }

    private String obtainBucket(Message<?> requestMessage) {
        String bucketName = this.bucketExpression instanceof LiteralExpression ? (String)this.bucketExpression.getValue() : (String)this.bucketExpression.getValue(this.evaluationContext, requestMessage, String.class);
        Assert.state((bucketName != null ? 1 : 0) != 0, () -> "The 'bucketExpression' [" + this.bucketExpression.getExpressionString() + "] must not evaluate to null. Root object is: " + requestMessage);
        return bucketName;
    }

    public static enum Command {
        UPLOAD,
        DOWNLOAD,
        COPY;

    }
}

