/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aws.support;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.springframework.integration.aws.support.S3SessionFactory;
import org.springframework.integration.file.remote.ClientCallback;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.file.remote.session.SessionFactory;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.S3Object;

public class S3RemoteFileTemplate
extends RemoteFileTemplate<S3Object> {
    public S3RemoteFileTemplate() {
        this(new S3SessionFactory());
    }

    public S3RemoteFileTemplate(S3Client amazonS3) {
        this(new S3SessionFactory(amazonS3));
    }

    public S3RemoteFileTemplate(SessionFactory<S3Object> sessionFactory) {
        super(sessionFactory);
    }

    public <T, C> T executeWithClient(ClientCallback<C, T> callback) {
        return (T)callback.doWithClient(this.sessionFactory.getSession().getClientInstance());
    }

    public boolean exists(String path) {
        try {
            return this.sessionFactory.getSession().exists(path);
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Failed to check the path " + path, ex);
        }
    }
}

