/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.feed.config;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.io.Resource;
import org.springframework.integration.config.xml.AbstractPollingInboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.feed.inbound.FeedEntryMessageSource;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class FeedInboundChannelAdapterParser
extends AbstractPollingInboundChannelAdapterParser {
    protected BeanMetadataElement parseSource(Element element, ParserContext parserContext) {
        String resource;
        boolean hasResource;
        BeanDefinitionBuilder sourceBuilder = BeanDefinitionBuilder.genericBeanDefinition(FeedEntryMessageSource.class);
        String url = element.getAttribute("url");
        boolean hasUrl = StringUtils.hasText((String)url);
        if (hasUrl == (hasResource = StringUtils.hasText((String)(resource = element.getAttribute("resource"))))) {
            parserContext.getReaderContext().error("Exactly one of the 'url' or 'resource' is required.", (Object)element);
        }
        if (hasUrl) {
            sourceBuilder.addConstructorArgValue((Object)url);
        } else {
            sourceBuilder.getBeanDefinition().getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)resource, Resource.class.getName());
        }
        sourceBuilder.getBeanDefinition().getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)element.getAttribute("id"));
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)sourceBuilder, (Element)element, (String)"metadata-store");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)sourceBuilder, (Element)element, (String)"feed-input", (String)"syndFeedInput");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)sourceBuilder, (Element)element, (String)"preserve-wire-feed");
        return sourceBuilder.getBeanDefinition();
    }
}

