/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file;

import java.io.File;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.file.FileNameGenerator;
import org.springframework.integration.util.AbstractExpressionEvaluator;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultFileNameGenerator
extends AbstractExpressionEvaluator
implements FileNameGenerator {
    private static final String DEFAULT_EXPRESSION = "headers['file_name']";
    private static final ExpressionParser parser = new SpelExpressionParser();
    private volatile Expression expression = parser.parseExpression("headers['file_name']");

    public void setExpression(String expression) {
        Assert.hasText((String)expression, (String)"expression must not be empty");
        this.expression = parser.parseExpression(expression);
    }

    public void setHeaderName(String headerName) {
        Assert.notNull((Object)headerName, (String)"'headerName' must not be null");
        this.expression = parser.parseExpression("headers['" + headerName + "']");
    }

    @Override
    public String generateFileName(Message<?> message) {
        Object filenameProperty = this.evaluateExpression(this.expression, message);
        if (filenameProperty instanceof String && StringUtils.hasText((String)((String)filenameProperty))) {
            return (String)filenameProperty;
        }
        if (message.getPayload() instanceof File) {
            return ((File)message.getPayload()).getName();
        }
        return message.getHeaders().getId() + ".msg";
    }
}

