/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.filters;

import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.springframework.integration.file.filters.AbstractFileListFilter;
import org.springframework.integration.file.filters.ReversibleFileListFilter;

public class AcceptOnceFileListFilter<F>
extends AbstractFileListFilter<F>
implements ReversibleFileListFilter<F> {
    private final Queue<F> seen;
    private final Object monitor = new Object();

    public AcceptOnceFileListFilter(int maxCapacity) {
        this.seen = new LinkedBlockingQueue<F>(maxCapacity);
    }

    public AcceptOnceFileListFilter() {
        this.seen = new LinkedBlockingQueue<F>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean accept(F file) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.seen.contains(file)) {
                return false;
            }
            if (!this.seen.offer(file)) {
                this.seen.poll();
                this.seen.add(file);
            }
            return true;
        }
    }

    @Override
    public void rollback(F file, List<F> files) {
        boolean rollingBack = false;
        for (F fileToRollback : files) {
            if (fileToRollback.equals(file)) {
                rollingBack = true;
            }
            if (!rollingBack) continue;
            this.seen.remove(fileToRollback);
        }
    }
}

