/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.splitter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import org.springframework.integration.splitter.AbstractMessageSplitter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;

public class FileSplitter
extends AbstractMessageSplitter {
    private final boolean iterator;
    private final boolean markers;
    private Charset charset;

    public FileSplitter() {
        this(true, false);
    }

    public FileSplitter(boolean iterator) {
        this(iterator, false);
    }

    public FileSplitter(boolean iterator, boolean markers) {
        this.iterator = iterator;
        this.markers = markers;
        if (markers) {
            this.setApplySequence(false);
        }
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    protected Object splitMessage(final Message<?> message) {
        String filePath;
        Object payload = message.getPayload();
        Reader reader = null;
        if (payload instanceof String) {
            try {
                reader = new FileReader((String)payload);
                filePath = (String)payload;
            }
            catch (FileNotFoundException e) {
                throw new MessageHandlingException(message, "failed to read file [" + payload + "]", (Throwable)e);
            }
        } else if (payload instanceof File) {
            try {
                reader = this.charset == null ? new FileReader((File)payload) : new InputStreamReader((InputStream)new FileInputStream((File)payload), this.charset);
                filePath = ((File)payload).getAbsolutePath();
            }
            catch (FileNotFoundException e) {
                throw new MessageHandlingException(message, "failed to read file [" + payload + "]", (Throwable)e);
            }
        } else if (payload instanceof InputStream) {
            reader = this.charset == null ? new InputStreamReader((InputStream)payload) : new InputStreamReader((InputStream)payload, this.charset);
            filePath = ":stream:";
        } else if (payload instanceof Reader) {
            reader = (Reader)payload;
            filePath = ":reader:";
        } else {
            return message;
        }
        final BufferedReader bufferedReader = new BufferedReader(reader);
        Iterator<Object> iterator = new Iterator<Object>(){
            boolean markers;
            boolean sof;
            boolean eof;
            boolean done;
            {
                this.sof = this.markers = FileSplitter.this.markers;
            }

            @Override
            public boolean hasNext() {
                try {
                    boolean ready;
                    boolean bl = ready = !this.done && bufferedReader.ready();
                    if (!ready) {
                        if (this.markers) {
                            this.eof = true;
                        }
                        bufferedReader.close();
                    }
                    return this.sof || ready || this.eof;
                }
                catch (IOException e) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw new MessageHandlingException(message, "IOException while iterating", (Throwable)e);
                }
            }

            @Override
            public Object next() {
                if (this.sof) {
                    this.sof = false;
                    return new FileMarker(filePath, FileMarker.Mark.START);
                }
                if (this.eof) {
                    this.eof = false;
                    this.markers = false;
                    this.done = true;
                    return new FileMarker(filePath, FileMarker.Mark.END);
                }
                try {
                    return bufferedReader.readLine();
                }
                catch (IOException e) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw new MessageHandlingException(message, "IOException while iterating", (Throwable)e);
                }
            }
        };
        if (this.iterator) {
            return iterator;
        }
        ArrayList lines = new ArrayList();
        while (iterator.hasNext()) {
            lines.add(iterator.next());
        }
        return lines;
    }

    public static class FileMarker
    implements Serializable {
        private static final long serialVersionUID = 8514605438145748406L;
        private final String filePath;
        private final Mark mark;

        public FileMarker(String filePath, Mark mark) {
            this.filePath = filePath;
            this.mark = mark;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public Mark getMark() {
            return this.mark;
        }

        public String toString() {
            return "FileMarker [filePath=" + this.filePath + ", mark=" + this.mark + "]";
        }

        public static enum Mark implements Serializable
        {
            START,
            END;

        }
    }
}

