/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.tail;

import java.time.Duration;
import org.apache.commons.io.input.Tailer;
import org.apache.commons.io.input.TailerListener;
import org.apache.commons.io.input.TailerListenerAdapter;
import org.springframework.integration.file.tail.FileTailingMessageProducerSupport;

public class ApacheCommonsFileTailingMessageProducer
extends FileTailingMessageProducerSupport
implements TailerListener {
    private final TailerListener tailerListener = new IntegrationTailerListener();
    private Duration pollingDelay = Duration.ofSeconds(1L);
    private boolean end = true;
    private boolean reopen = false;
    private volatile Tailer tailer;

    public void setPollingDelay(long pollingDelay) {
        this.setPollingDelayDuration(Duration.ofMillis(pollingDelay));
    }

    public void setPollingDelayDuration(Duration pollingDelay) {
        this.pollingDelay = pollingDelay;
    }

    public void setEnd(boolean end) {
        this.end = end;
    }

    public void setReopen(boolean reopen) {
        this.reopen = reopen;
    }

    @Override
    public String getComponentType() {
        return super.getComponentType() + " (Apache)";
    }

    @Override
    protected void doStart() {
        super.doStart();
        Tailer theTailer = ((Tailer.Builder)Tailer.builder().setDelayDuration(this.pollingDelay).setTailFromEnd(this.end).setReOpen(this.reopen).setFile(this.getFile())).setTailerListener(this.tailerListener).setStartThread(false).get();
        this.getTaskExecutor().execute((Runnable)theTailer);
        this.tailer = theTailer;
    }

    @Override
    protected void doStop() {
        super.doStop();
        this.tailer.close();
    }

    @Deprecated(since="6.2", forRemoval=true)
    public void init(Tailer tailer) {
        this.tailerListenerIsDeprecatedError();
    }

    @Deprecated(since="6.2", forRemoval=true)
    public void fileNotFound() {
        this.tailerListenerIsDeprecatedError();
        this.tailerListener.fileNotFound();
    }

    @Deprecated(since="6.2", forRemoval=true)
    public void fileRotated() {
        this.tailerListenerIsDeprecatedError();
        this.tailerListener.fileRotated();
    }

    @Deprecated(since="6.2", forRemoval=true)
    public void handle(String line) {
        this.tailerListenerIsDeprecatedError();
        this.tailerListener.handle(line);
    }

    @Deprecated(since="6.2", forRemoval=true)
    public void handle(Exception ex) {
        this.tailerListenerIsDeprecatedError();
        this.tailerListener.handle(ex);
    }

    private void tailerListenerIsDeprecatedError() {
        this.logger.error((CharSequence)"The 'TailerListener' implementation on the 'ApacheCommonsFileTailingMessageProducer' is deprecated (in favor of an internal instance) for removal in the next version.");
    }

    private class IntegrationTailerListener
    extends TailerListenerAdapter {
        IntegrationTailerListener() {
        }

        public void fileNotFound() {
            ApacheCommonsFileTailingMessageProducer.this.publish("File not found: " + ApacheCommonsFileTailingMessageProducer.this.getFile().getAbsolutePath());
            try {
                Thread.sleep(ApacheCommonsFileTailingMessageProducer.this.getMissingFileDelay());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        public void fileRotated() {
            ApacheCommonsFileTailingMessageProducer.this.publish("File rotated: " + ApacheCommonsFileTailingMessageProducer.this.getFile().getAbsolutePath());
        }

        public void handle(String line) {
            ApacheCommonsFileTailingMessageProducer.this.send(line);
        }

        public void handle(Exception ex) {
            ApacheCommonsFileTailingMessageProducer.this.publish(ex.getMessage());
        }
    }
}

