/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.remote;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.expression.Expression;
import org.springframework.integration.file.DefaultFileNameGenerator;
import org.springframework.integration.file.FileNameGenerator;
import org.springframework.integration.file.remote.ClientCallback;
import org.springframework.integration.file.remote.InputStreamCallback;
import org.springframework.integration.file.remote.RemoteFileOperations;
import org.springframework.integration.file.remote.RemoteFileUtils;
import org.springframework.integration.file.remote.SessionCallback;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.support.FileExistsMode;
import org.springframework.integration.handler.ExpressionEvaluatingMessageProcessor;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RemoteFileTemplate<F>
implements RemoteFileOperations<F>,
InitializingBean,
BeanFactoryAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final SessionFactory<F> sessionFactory;
    private final ThreadLocal<@Nullable Session<F>> contextSessions = new ThreadLocal();
    private final AtomicInteger activeTemplateCallbacks = new AtomicInteger();
    private String temporaryFileSuffix = ".writing";
    private boolean autoCreateDirectory = false;
    private boolean useTemporaryFileName = true;
    private @Nullable ExpressionEvaluatingMessageProcessor<String> directoryExpressionProcessor;
    private @Nullable ExpressionEvaluatingMessageProcessor<String> temporaryDirectoryExpressionProcessor;
    private @Nullable ExpressionEvaluatingMessageProcessor<String> fileNameProcessor;
    private FileNameGenerator fileNameGenerator = new DefaultFileNameGenerator();
    private boolean fileNameGeneratorSet;
    private Charset charset = StandardCharsets.UTF_8;
    private String remoteFileSeparator = "/";
    private boolean hasExplicitlySetSuffix;
    private BeanFactory beanFactory;

    public RemoteFileTemplate(SessionFactory<F> sessionFactory) {
        Assert.notNull(sessionFactory, (String)"sessionFactory must not be null");
        this.sessionFactory = sessionFactory;
    }

    public SessionFactory<F> getSessionFactory() {
        return this.sessionFactory;
    }

    public void setAutoCreateDirectory(boolean autoCreateDirectory) {
        this.autoCreateDirectory = autoCreateDirectory;
    }

    public void setRemoteFileSeparator(String remoteFileSeparator) {
        Assert.notNull((Object)remoteFileSeparator, (String)"'remoteFileSeparator' must not be null");
        this.remoteFileSeparator = remoteFileSeparator;
    }

    public final String getRemoteFileSeparator() {
        return this.remoteFileSeparator;
    }

    public void setRemoteDirectoryExpression(Expression remoteDirectoryExpression) {
        Assert.notNull((Object)remoteDirectoryExpression, (String)"remoteDirectoryExpression must not be null");
        this.directoryExpressionProcessor = new ExpressionEvaluatingMessageProcessor(remoteDirectoryExpression, String.class);
    }

    public @Nullable MessageProcessor<String> getDirectoryExpressionProcessor() {
        return this.directoryExpressionProcessor;
    }

    public void setTemporaryRemoteDirectoryExpression(Expression temporaryRemoteDirectoryExpression) {
        Assert.notNull((Object)temporaryRemoteDirectoryExpression, (String)"temporaryRemoteDirectoryExpression must not be null");
        this.temporaryDirectoryExpressionProcessor = new ExpressionEvaluatingMessageProcessor(temporaryRemoteDirectoryExpression, String.class);
    }

    public void setFileNameExpression(Expression fileNameExpression) {
        Assert.notNull((Object)fileNameExpression, (String)"fileNameExpression must not be null");
        this.fileNameProcessor = new ExpressionEvaluatingMessageProcessor(fileNameExpression, String.class);
    }

    public String getTemporaryFileSuffix() {
        return this.temporaryFileSuffix;
    }

    public boolean isUseTemporaryFileName() {
        return this.useTemporaryFileName;
    }

    public void setUseTemporaryFileName(boolean useTemporaryFileName) {
        this.useTemporaryFileName = useTemporaryFileName;
    }

    public void setFileNameGenerator(@Nullable FileNameGenerator fileNameGenerator) {
        this.fileNameGenerator = fileNameGenerator != null ? fileNameGenerator : new DefaultFileNameGenerator();
        this.fileNameGeneratorSet = fileNameGenerator != null;
    }

    public void setCharset(String charset) {
        this.charset = Charset.forName(charset);
    }

    public void setTemporaryFileSuffix(String temporaryFileSuffix) {
        Assert.notNull((Object)temporaryFileSuffix, (String)"'temporaryFileSuffix' must not be null");
        this.hasExplicitlySetSuffix = true;
        this.temporaryFileSuffix = temporaryFileSuffix;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() {
        if (this.directoryExpressionProcessor != null) {
            this.directoryExpressionProcessor.setBeanFactory(this.beanFactory);
        }
        if (this.temporaryDirectoryExpressionProcessor != null) {
            this.temporaryDirectoryExpressionProcessor.setBeanFactory(this.beanFactory);
        }
        if (!this.fileNameGeneratorSet && this.fileNameGenerator instanceof BeanFactoryAware) {
            ((BeanFactoryAware)this.fileNameGenerator).setBeanFactory(this.beanFactory);
        }
        if (this.fileNameProcessor != null) {
            this.fileNameProcessor.setBeanFactory(this.beanFactory);
        }
        if (this.autoCreateDirectory) {
            Assert.hasText((String)this.remoteFileSeparator, (String)"'remoteFileSeparator' must not be empty when 'autoCreateDirectory' is set to 'true'");
        }
        if (this.hasExplicitlySetSuffix && !this.useTemporaryFileName) {
            this.logger.warn((Object)"Since 'use-temporary-file-name' is set to 'false' the value of 'temporary-file-suffix' has no effect");
        }
    }

    @Override
    public @Nullable String append(Message<?> message) {
        return this.append(message, null);
    }

    @Override
    public @Nullable String append(Message<?> message, @Nullable String subDirectory) {
        return this.send(message, subDirectory, FileExistsMode.APPEND);
    }

    @Override
    public @Nullable String send(Message<?> message, FileExistsMode ... mode) {
        return this.send(message, (String)null, mode);
    }

    @Override
    public @Nullable String send(Message<?> message, @Nullable String subDirectory, FileExistsMode ... mode) {
        FileExistsMode modeToUse = mode == null || mode.length < 1 || mode[0] == null ? FileExistsMode.REPLACE : mode[0];
        return this.send(message, subDirectory, modeToUse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable String send(Message<?> message, @Nullable String subDirectory, FileExistsMode mode) {
        Assert.isTrue((!FileExistsMode.REPLACE_IF_MODIFIED.equals((Object)mode) ? 1 : 0) != 0, (String)"FilExistsMode.REPLACE_IF_MODIFIED can only be used for local files");
        StreamHolder inputStreamHolder = this.payloadToInputStream(message);
        if (inputStreamHolder != null) {
            try {
                String string = this.execute(session -> this.doSend(message, subDirectory, mode, inputStreamHolder, session));
                return string;
            }
            finally {
                try {
                    inputStreamHolder.stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("File " + String.valueOf(message.getPayload()) + " does not exist"));
        }
        return null;
    }

    private String doSend(Message<?> message, @Nullable String subDirectory, FileExistsMode mode, StreamHolder inputStreamHolder, Session<F> session) {
        String fileName = inputStreamHolder.name;
        try {
            Assert.notNull(this.directoryExpressionProcessor, (String)"'remoteDirectoryExpression' is required");
            Object remoteDirectory = (String)this.directoryExpressionProcessor.processMessage(message);
            remoteDirectory = this.normalizeDirectoryPath((String)remoteDirectory);
            if (StringUtils.hasText((String)subDirectory)) {
                remoteDirectory = subDirectory.startsWith(this.remoteFileSeparator) ? (String)remoteDirectory + subDirectory.substring(1) : (String)remoteDirectory + this.normalizeDirectoryPath(subDirectory);
            }
            String temporaryRemoteDirectory = remoteDirectory;
            if (this.temporaryDirectoryExpressionProcessor != null) {
                temporaryRemoteDirectory = (String)this.temporaryDirectoryExpressionProcessor.processMessage(message);
            }
            fileName = this.fileNameGenerator.generateFileName(message);
            this.sendFileToRemoteDirectory(inputStreamHolder.stream, temporaryRemoteDirectory, (String)remoteDirectory, fileName, session, mode);
            return (String)remoteDirectory + fileName;
        }
        catch (FileNotFoundException e) {
            throw new MessageDeliveryException(message, "File [" + inputStreamHolder.name + "] not found in local working directory; it was moved or deleted unexpectedly.", (Throwable)e);
        }
        catch (IOException e) {
            throw new MessageDeliveryException(message, "Failed to transfer file [" + inputStreamHolder.name + " -> " + fileName + "] from local directory to remote directory.", (Throwable)e);
        }
        catch (Exception e) {
            throw new MessageDeliveryException(message, "Error handling message for file [" + inputStreamHolder.name + " -> " + fileName + "]", (Throwable)e);
        }
    }

    @Override
    public boolean exists(String path) {
        return Boolean.TRUE.equals(this.execute(session -> session.exists(path)));
    }

    @Override
    public boolean remove(String path) {
        return Boolean.TRUE.equals(this.execute(session -> session.remove(path)));
    }

    @Override
    public void rename(String fromPath, String toPath) {
        Assert.hasText((String)fromPath, (String)"Old filename cannot be null or empty");
        Assert.hasText((String)toPath, (String)"New filename cannot be null or empty");
        this.execute(session -> {
            int lastSeparator = toPath.lastIndexOf(this.remoteFileSeparator);
            if (lastSeparator > 0) {
                String remoteFileDirectory = toPath.substring(0, lastSeparator + 1);
                RemoteFileUtils.makeDirectories(remoteFileDirectory, session, this.remoteFileSeparator, this.logger);
            }
            session.rename(fromPath, toPath);
        });
    }

    @Override
    public boolean get(Message<?> message, InputStreamCallback callback) {
        Assert.notNull(this.fileNameProcessor, (String)"A 'fileNameExpression' is needed to use get");
        String remotePath = (String)this.fileNameProcessor.processMessage(message);
        Assert.notNull((Object)remotePath, (String)"'remotePath' cannot be null");
        return this.get(remotePath, callback);
    }

    @Override
    public boolean get(String remotePath, InputStreamCallback callback) {
        Boolean result = this.execute(session -> {
            try (InputStream inputStream = session.readRaw(remotePath);){
                callback.doWithInputStream(inputStream);
                Boolean bl = session.finalizeRaw();
                return bl;
            }
        });
        return Boolean.TRUE.equals(result);
    }

    @Override
    public F[] list(@Nullable String path) {
        return this.execute(session -> session.list(path));
    }

    @Override
    public Session<F> getSession() {
        Session<F> session;
        if (this.activeTemplateCallbacks.get() > 0 && (session = this.contextSessions.get()) != null) {
            return session;
        }
        return this.sessionFactory.getSession();
    }

    @Override
    public <T> @Nullable T execute(SessionCallback<F, T> callback) {
        Session<F> session = null;
        boolean invokeScope = false;
        if (this.activeTemplateCallbacks.get() > 0) {
            session = this.contextSessions.get();
        }
        try {
            if (session == null) {
                session = this.sessionFactory.getSession();
            } else {
                invokeScope = true;
            }
            T t = callback.doInSession(session);
            return t;
        }
        catch (Exception ex) {
            if (session != null && this.shouldMarkSessionAsDirty(ex)) {
                session.dirty();
            }
            if (ex instanceof MessagingException) {
                MessagingException messagingException = (MessagingException)ex;
                throw messagingException;
            }
            throw new MessagingException("Failed to execute on session", (Throwable)ex);
        }
        finally {
            if (!invokeScope && session != null) {
                try {
                    session.close();
                }
                catch (Exception ex) {
                    this.logger.debug((Object)"failed to close Session", (Throwable)ex);
                }
            }
        }
    }

    protected boolean shouldMarkSessionAsDirty(Exception ex) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> @Nullable T invoke(RemoteFileOperations.OperationsCallback<F, T> action) {
        Session<F> contextSession = this.contextSessions.get();
        if (contextSession == null) {
            this.contextSessions.set(this.sessionFactory.getSession());
        }
        this.activeTemplateCallbacks.incrementAndGet();
        try {
            T t = action.doInOperations(this);
            return t;
        }
        finally {
            this.activeTemplateCallbacks.decrementAndGet();
            if (contextSession == null) {
                Session<F> session = this.contextSessions.get();
                if (session != null) {
                    session.close();
                }
                this.contextSessions.remove();
            }
        }
    }

    @Override
    public <T, C> @Nullable T executeWithClient(ClientCallback<C, T> callback) {
        throw new UnsupportedOperationException("executeWithClient() is not supported by the generic template");
    }

    private @Nullable StreamHolder payloadToInputStream(Message<?> message) throws MessageDeliveryException {
        block9: {
            Object payload = message.getPayload();
            try {
                if (payload instanceof File) {
                    File inputFile = (File)payload;
                    if (inputFile.exists()) {
                        return new StreamHolder(new BufferedInputStream(new FileInputStream(inputFile)), inputFile.getAbsolutePath());
                    }
                    break block9;
                }
                if (payload instanceof byte[] || payload instanceof String) {
                    String name;
                    byte[] bytes;
                    if (payload instanceof String) {
                        bytes = ((String)payload).getBytes(this.charset);
                        name = "String payload";
                    } else {
                        bytes = (byte[])payload;
                        name = "byte[] payload";
                    }
                    return new StreamHolder(new ByteArrayInputStream(bytes), name);
                }
                if (payload instanceof InputStream) {
                    return new StreamHolder((InputStream)payload, "InputStream payload");
                }
                if (payload instanceof Resource) {
                    Resource resource = (Resource)payload;
                    String filename = resource.getFilename();
                    return new StreamHolder(resource.getInputStream(), filename != null ? filename : "Resource payload");
                }
                throw new IllegalArgumentException("Unsupported payload type [" + payload.getClass().getName() + "]. The only supported payloads are java.io.File, java.lang.String, byte[], and InputStream");
            }
            catch (Exception e) {
                throw new MessageDeliveryException(message, "Failed to create sendable file.", (Throwable)e);
            }
        }
        return null;
    }

    private void sendFileToRemoteDirectory(InputStream inputStream, @Nullable String temporaryRemoteDirectoryArg, String remoteDirectoryArg, String fileName, Session<F> session, FileExistsMode mode) throws IOException {
        String tempFilePath;
        String remoteFilePath;
        block13: {
            String remoteDirectory = this.normalizeDirectoryPath(remoteDirectoryArg);
            String temporaryRemoteDirectory = this.normalizeDirectoryPath(temporaryRemoteDirectoryArg);
            remoteFilePath = remoteDirectory + fileName;
            tempFilePath = temporaryRemoteDirectory + fileName;
            if (!FileExistsMode.APPEND.equals((Object)mode) && this.useTemporaryFileName) {
                tempFilePath = tempFilePath + this.temporaryFileSuffix;
            }
            if (this.autoCreateDirectory) {
                try {
                    RemoteFileUtils.makeDirectories(remoteDirectory, session, this.remoteFileSeparator, this.logger);
                    if (!temporaryRemoteDirectory.equals(remoteDirectory)) {
                        RemoteFileUtils.makeDirectories(temporaryRemoteDirectory, session, this.remoteFileSeparator, this.logger);
                    }
                }
                catch (IllegalStateException e) {
                    session.mkdir(remoteDirectory);
                    if (temporaryRemoteDirectory.equals(remoteDirectory)) break block13;
                    session.mkdir(temporaryRemoteDirectory);
                }
            }
        }
        try (InputStream stream = inputStream;){
            this.doSend(session, mode, remoteFilePath, tempFilePath, stream);
        }
        catch (Exception e) {
            throw new MessagingException("Failed to write to '" + tempFilePath + "' while uploading the file", (Throwable)e);
        }
    }

    private void doSend(Session<F> session, FileExistsMode mode, String remoteFilePath, String tempFilePath, InputStream stream) throws IOException {
        boolean rename = this.useTemporaryFileName;
        if (FileExistsMode.REPLACE.equals((Object)mode)) {
            session.write(stream, tempFilePath);
        } else if (FileExistsMode.APPEND.equals((Object)mode)) {
            session.append(stream, tempFilePath);
        } else if (session.exists(remoteFilePath)) {
            if (FileExistsMode.FAIL.equals((Object)mode)) {
                throw new MessagingException("The destination file already exists at '" + remoteFilePath + "'.");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("File not transferred to '" + remoteFilePath + "'; already exists."));
            }
            rename = false;
        } else {
            session.write(stream, tempFilePath);
        }
        if (rename) {
            session.rename(tempFilePath, remoteFilePath);
        }
    }

    private String normalizeDirectoryPath(@Nullable String directoryPath) {
        if (!StringUtils.hasText((String)directoryPath)) {
            return "";
        }
        if (!directoryPath.endsWith(this.remoteFileSeparator)) {
            return directoryPath + this.remoteFileSeparator;
        }
        return directoryPath;
    }

    private record StreamHolder(InputStream stream, String name) {
    }
}

