/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ftp.inbound;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.net.ftp.FTPFile;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.remote.AbstractFileInfo;
import org.springframework.integration.file.remote.AbstractRemoteFileStreamingMessageSource;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.ftp.filters.FtpPersistentAcceptOnceFileListFilter;
import org.springframework.integration.ftp.session.FtpFileInfo;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.integration.metadata.SimpleMetadataStore;

public class FtpStreamingMessageSource
extends AbstractRemoteFileStreamingMessageSource<FTPFile> {
    public FtpStreamingMessageSource(RemoteFileTemplate<FTPFile> template) {
        this(template, null);
    }

    public FtpStreamingMessageSource(RemoteFileTemplate<FTPFile> template, Comparator<AbstractFileInfo<FTPFile>> comparator) {
        super(template, comparator);
        this.doSetFilter((FileListFilter)new FtpPersistentAcceptOnceFileListFilter((ConcurrentMetadataStore)new SimpleMetadataStore(), "ftpStreamingMessageSource"));
    }

    public String getComponentType() {
        return "ftp:inbound-streaming-channel-adapter";
    }

    protected List<AbstractFileInfo<FTPFile>> asFileInfoList(Collection<FTPFile> files) {
        ArrayList<AbstractFileInfo<FTPFile>> canonicalFiles = new ArrayList<AbstractFileInfo<FTPFile>>();
        for (FTPFile file : files) {
            canonicalFiles.add(new FtpFileInfo(file));
        }
        return canonicalFiles;
    }
}

