/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.groovy;

import groovy.lang.Binding;
import groovy.lang.GString;
import java.util.Map;
import org.springframework.integration.Message;
import org.springframework.integration.groovy.BindingOverwriteGroovyObjectCustomizerDecorator;
import org.springframework.integration.groovy.VariableBindingGroovyObjectCustomizerDecorator;
import org.springframework.integration.scripting.AbstractScriptExecutingMessageProcessor;
import org.springframework.integration.scripting.ScriptVariableGenerator;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.groovy.GroovyObjectCustomizer;
import org.springframework.scripting.groovy.GroovyScriptFactory;
import org.springframework.scripting.support.StaticScriptSource;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyCommandMessageProcessor
extends AbstractScriptExecutingMessageProcessor<Object> {
    private volatile GroovyObjectCustomizer customizer;
    private Binding binding;

    public GroovyCommandMessageProcessor() {
    }

    public GroovyCommandMessageProcessor(ScriptVariableGenerator scriptVariableGenerator) {
        super(scriptVariableGenerator);
    }

    public GroovyCommandMessageProcessor(Binding binding) {
        this();
        Assert.notNull((Object)binding, (String)"binding must not be null");
        this.binding = binding;
    }

    public GroovyCommandMessageProcessor(Binding binding, ScriptVariableGenerator scriptVariableGenerator) {
        this(scriptVariableGenerator);
        Assert.notNull((Object)binding, (String)"binding must not be null");
        this.binding = binding;
    }

    public void setCustomizer(GroovyObjectCustomizer customizer) {
        this.customizer = customizer;
    }

    protected ScriptSource getScriptSource(Message<?> message) {
        Object payload = message.getPayload();
        Assert.isInstanceOf(String.class, (Object)payload, (String)"Payload must be a String containing a Groovy script.");
        String className = this.generateScriptName(message);
        return new StaticScriptSource((String)payload, className);
    }

    protected Object executeScript(ScriptSource scriptSource, Map<String, Object> variables) throws Exception {
        Object result;
        VariableBindingGroovyObjectCustomizerDecorator customizerDecorator;
        Assert.notNull((Object)scriptSource, (String)"scriptSource must not be null");
        VariableBindingGroovyObjectCustomizerDecorator variableBindingGroovyObjectCustomizerDecorator = customizerDecorator = this.binding != null ? new BindingOverwriteGroovyObjectCustomizerDecorator(this.binding) : new VariableBindingGroovyObjectCustomizerDecorator();
        if (this.customizer != null) {
            customizerDecorator.setCustomizer(this.customizer);
        }
        if (!CollectionUtils.isEmpty(variables)) {
            customizerDecorator.setVariables(variables);
        }
        GroovyScriptFactory factory = new GroovyScriptFactory(((Object)((Object)this)).getClass().getSimpleName(), (GroovyObjectCustomizer)customizerDecorator);
        if (this.getBeanClassLoader() != null) {
            factory.setBeanClassLoader(this.getBeanClassLoader());
        }
        if (this.getBeanFactory() != null) {
            factory.setBeanFactory(this.getBeanFactory());
        }
        return (result = factory.getScriptedObject(scriptSource, null)) instanceof GString ? result.toString() : result;
    }

    protected String generateScriptName(Message<?> message) {
        return ((Object)((Object)this)).getClass().getSimpleName() + message.getHeaders().getId().toString().replaceAll("-", "");
    }
}

