/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.groovy;

import groovy.lang.GString;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.Message;
import org.springframework.integration.groovy.VariableBindingGroovyObjectCustomizerDecorator;
import org.springframework.integration.scripting.AbstractScriptExecutingMessageProcessor;
import org.springframework.integration.scripting.ScriptVariableGenerator;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.groovy.GroovyObjectCustomizer;
import org.springframework.scripting.groovy.GroovyScriptFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyScriptExecutingMessageProcessor
extends AbstractScriptExecutingMessageProcessor<Object>
implements InitializingBean {
    private final GroovyScriptFactory scriptFactory;
    private final VariableBindingGroovyObjectCustomizerDecorator customizerDecorator = new VariableBindingGroovyObjectCustomizerDecorator();
    private volatile ScriptSource scriptSource;

    public GroovyScriptExecutingMessageProcessor(ScriptSource scriptSource) {
        this.scriptSource = scriptSource;
        this.scriptFactory = new GroovyScriptFactory(((Object)((Object)this)).getClass().getSimpleName(), (GroovyObjectCustomizer)this.customizerDecorator);
    }

    public GroovyScriptExecutingMessageProcessor(ScriptSource scriptSource, ScriptVariableGenerator scriptVariableGenerator) {
        super(scriptVariableGenerator);
        this.scriptSource = scriptSource;
        this.scriptFactory = new GroovyScriptFactory(((Object)((Object)this)).getClass().getSimpleName(), (GroovyObjectCustomizer)this.customizerDecorator);
    }

    public void setCustomizer(GroovyObjectCustomizer customizer) {
        this.customizerDecorator.setCustomizer(customizer);
    }

    protected ScriptSource getScriptSource(Message<?> message) {
        return this.scriptSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object executeScript(ScriptSource scriptSource, Map<String, Object> variables) throws Exception {
        Assert.notNull((Object)scriptSource, (String)"scriptSource must not be null");
        GroovyScriptExecutingMessageProcessor groovyScriptExecutingMessageProcessor = this;
        synchronized (groovyScriptExecutingMessageProcessor) {
            Object result;
            if (!CollectionUtils.isEmpty(variables)) {
                this.customizerDecorator.setVariables(variables);
            }
            Object object = (result = this.scriptFactory.getScriptedObject(scriptSource, null)) instanceof GString ? result.toString() : result;
            return object;
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.getBeanClassLoader() != null) {
            this.scriptFactory.setBeanClassLoader(this.getBeanClassLoader());
        }
        if (this.getBeanFactory() != null) {
            this.scriptFactory.setBeanFactory(this.getBeanFactory());
        }
    }
}

