/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.hazelcast.leader;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ILock;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.leader.Candidate;
import org.springframework.integration.leader.Context;
import org.springframework.integration.leader.DefaultCandidate;
import org.springframework.integration.leader.event.DefaultLeaderEventPublisher;
import org.springframework.integration.leader.event.LeaderEventPublisher;
import org.springframework.util.Assert;

public class LeaderInitiator
implements SmartLifecycle,
DisposableBean,
ApplicationEventPublisherAware {
    private static final Log logger = LogFactory.getLog(LeaderInitiator.class);
    private static int threadNameCount = 0;
    private static final Context NULL_CONTEXT = new NullContext();
    private final HazelcastInstance client;
    private final Candidate candidate;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "Hazelcast-leadership-" + threadNameCount++);
            thread.setDaemon(true);
            return thread;
        }
    });
    private volatile Future<Void> future;
    private volatile ILock lock;
    private LeaderSelector leaderSelector;
    private volatile LeaderEventPublisher leaderEventPublisher = new DefaultLeaderEventPublisher();
    private boolean customPublisher = false;
    private volatile boolean autoStartup = true;
    private volatile int phase;
    private volatile boolean running;

    public LeaderInitiator(HazelcastInstance client) {
        this(client, (Candidate)new DefaultCandidate());
    }

    public LeaderInitiator(HazelcastInstance client, Candidate candidate) {
        Assert.notNull((Object)client, (String)"'client' must not be null");
        Assert.notNull((Object)candidate, (String)"'candidate' must not be null");
        this.client = client;
        this.candidate = candidate;
    }

    public void setLeaderEventPublisher(LeaderEventPublisher leaderEventPublisher) {
        Assert.notNull((Object)leaderEventPublisher, (String)"'leaderEventPublisher' must not be null");
        this.leaderEventPublisher = leaderEventPublisher;
        this.customPublisher = true;
    }

    public Context getContext() {
        if (this.leaderSelector == null) {
            return NULL_CONTEXT;
        }
        return this.leaderSelector.context;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        if (!this.customPublisher) {
            this.leaderEventPublisher = new DefaultLeaderEventPublisher(applicationEventPublisher);
        }
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public int getPhase() {
        return this.phase;
    }

    public synchronized void start() {
        if (!this.running) {
            this.lock = this.client.getLock(this.candidate.getRole());
            this.running = true;
            this.leaderSelector = new LeaderSelector();
            this.future = this.executorService.submit(this.leaderSelector);
        }
    }

    public void stop(Runnable callback) {
        this.stop();
        if (callback != null) {
            callback.run();
        }
    }

    public synchronized void stop() {
        if (this.running) {
            this.running = false;
            this.future.cancel(true);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void destroy() throws Exception {
        this.stop();
        this.executorService.shutdown();
    }

    private static final class NullContext
    implements Context {
        private NullContext() {
        }

        public boolean isLeader() {
            return false;
        }

        public void yield() {
        }
    }

    protected class HazelcastContext
    implements Context {
        protected HazelcastContext() {
        }

        public boolean isLeader() {
            return LeaderInitiator.this.leaderSelector.locked;
        }

        public void yield() {
            if (LeaderInitiator.this.future != null) {
                LeaderInitiator.this.future.cancel(true);
                LeaderInitiator.this.future = LeaderInitiator.this.executorService.submit(LeaderInitiator.this.leaderSelector);
            }
        }

        public String toString() {
            return "HazelcastContext{role=" + LeaderInitiator.this.candidate.getRole() + ", id=" + LeaderInitiator.this.candidate.getId() + ", isLeader=" + this.isLeader() + "}";
        }
    }

    protected class LeaderSelector
    implements Callable<Void> {
        protected final HazelcastContext context;
        protected final String role;
        private volatile boolean locked;

        protected LeaderSelector() {
            this.context = new HazelcastContext();
            this.role = LeaderInitiator.this.candidate.getRole();
            this.locked = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Void call() throws Exception {
            block16: while (true) {
                while (LeaderInitiator.this.running) {
                    try {
                        this.locked = LeaderInitiator.this.lock.tryLock(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                        if (!this.locked) continue block16;
                        try {
                            LeaderInitiator.this.leaderEventPublisher.publishOnGranted((Object)LeaderInitiator.this, (Context)this.context, this.role);
                        }
                        catch (Exception e) {
                            logger.warn((Object)"Error publishing OnGranted event.", (Throwable)e);
                        }
                        LeaderInitiator.this.candidate.onGranted((Context)this.context);
                        Thread.sleep(Long.MAX_VALUE);
                    }
                    catch (InterruptedException e) {
                        if (this.locked) {
                            LeaderInitiator.this.lock.unlock();
                            this.locked = false;
                            LeaderInitiator.this.candidate.onRevoked((Context)this.context);
                            if (LeaderInitiator.this.leaderEventPublisher != null) {
                                try {
                                    LeaderInitiator.this.leaderEventPublisher.publishOnRevoked((Object)LeaderInitiator.this, (Context)this.context, LeaderInitiator.this.candidate.getRole());
                                }
                                catch (Exception ex) {
                                    logger.warn((Object)"Error publishing OnRevoked event.", (Throwable)ex);
                                }
                            }
                            Thread.currentThread().interrupt();
                            Void void_ = null;
                            if (!this.locked) return void_;
                            LeaderInitiator.this.lock.unlock();
                            this.locked = false;
                            LeaderInitiator.this.candidate.onRevoked((Context)this.context);
                            if (LeaderInitiator.this.leaderEventPublisher == null) return void_;
                            try {
                                LeaderInitiator.this.leaderEventPublisher.publishOnRevoked((Object)LeaderInitiator.this, (Context)this.context, this.role);
                                return void_;
                            }
                            catch (Exception e2) {
                                logger.warn((Object)"Error publishing OnRevoked event.", (Throwable)e2);
                            }
                            return void_;
                        }
                        try {
                            continue block16;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                            return null;
                        }
                    }
                }
            }
            finally {
                if (this.locked) {
                    LeaderInitiator.this.lock.unlock();
                    this.locked = false;
                    LeaderInitiator.this.candidate.onRevoked((Context)this.context);
                    if (LeaderInitiator.this.leaderEventPublisher != null) {
                        try {
                            LeaderInitiator.this.leaderEventPublisher.publishOnRevoked((Object)LeaderInitiator.this, (Context)this.context, this.role);
                        }
                        catch (Exception e) {
                            logger.warn((Object)"Error publishing OnRevoked event.", (Throwable)e);
                        }
                    }
                }
            }
        }
    }
}

