/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.config;

import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.ExpressionFactoryBean;
import org.springframework.util.CollectionUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

abstract class HttpAdapterParsingUtils {
    static final String[] REST_TEMPLATE_REFERENCE_ATTRIBUTES = new String[]{"request-factory", "error-handler", "message-converters"};

    HttpAdapterParsingUtils() {
    }

    static void verifyNoRestTemplateAttributes(Element element, ParserContext parserContext) {
        for (String attributeName : REST_TEMPLATE_REFERENCE_ATTRIBUTES) {
            if (!element.hasAttribute(attributeName)) continue;
            parserContext.getReaderContext().error("When providing a 'rest-template' reference, the '" + attributeName + "' attribute is not allowed.", parserContext.extractSource((Object)element));
        }
    }

    static void configureUriVariableExpressions(BeanDefinitionBuilder builder, Element element) {
        List uriVariableElements = DomUtils.getChildElementsByTagName((Element)element, (String)"uri-variable");
        if (!CollectionUtils.isEmpty((Collection)uriVariableElements)) {
            ManagedMap uriVariableExpressions = new ManagedMap();
            for (Element uriVariableElement : uriVariableElements) {
                String name = uriVariableElement.getAttribute("name");
                String expression = uriVariableElement.getAttribute("expression");
                BeanDefinitionBuilder factoryBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition(ExpressionFactoryBean.class);
                factoryBeanBuilder.addConstructorArgValue((Object)expression);
                uriVariableExpressions.put((Object)name, (Object)factoryBeanBuilder.getBeanDefinition());
            }
            builder.addPropertyValue("uriVariableExpressions", (Object)uriVariableExpressions);
        }
    }
}

