/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.config;

import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.config.ExpressionFactoryBean;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class HttpInboundEndpointParser
extends AbstractSingleBeanDefinitionParser {
    private final boolean expectReply;

    public HttpInboundEndpointParser(boolean expectReply) {
        this.expectReply = expectReply;
    }

    protected String getBeanClassName(Element element) {
        return element.hasAttribute("view-name") ? "org.springframework.integration.http.inbound.HttpRequestHandlingController" : "org.springframework.integration.http.inbound.HttpRequestHandlingMessagingGateway";
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = super.resolveId(element, definition, parserContext);
        if (!StringUtils.hasText((String)id)) {
            id = element.getAttribute("name");
        } else if (!element.hasAttribute(this.getInputChannelAttributeName())) {
            id = id + ".adapter";
        }
        if (!StringUtils.hasText((String)id)) {
            id = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)definition, (BeanDefinitionRegistry)parserContext.getRegistry());
        }
        return id;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        List headerElements;
        builder.addConstructorArgValue((Object)this.expectReply);
        String inputChannelAttributeName = this.getInputChannelAttributeName();
        String inputChannelRef = element.getAttribute(inputChannelAttributeName);
        if (!StringUtils.hasText((String)inputChannelRef)) {
            if (this.expectReply) {
                parserContext.getReaderContext().error("a '" + inputChannelAttributeName + "' reference is required", (Object)element);
            } else {
                inputChannelRef = this.createDirectChannel(element, parserContext);
            }
        }
        builder.addPropertyReference("requestChannel", inputChannelRef);
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"error-channel");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"path");
        String payloadExpression = element.getAttribute("payload-expression");
        if (StringUtils.hasText((String)payloadExpression)) {
            RootBeanDefinition expressionDef = new RootBeanDefinition(ExpressionFactoryBean.class);
            expressionDef.getConstructorArgumentValues().addGenericArgumentValue((Object)payloadExpression);
            builder.addPropertyValue("payloadExpression", (Object)expressionDef);
        }
        if (!CollectionUtils.isEmpty((Collection)(headerElements = DomUtils.getChildElementsByTagName((Element)element, (String)"header")))) {
            ManagedMap headerElementsMap = new ManagedMap();
            for (Element headerElement : headerElements) {
                String name = headerElement.getAttribute("name");
                String expression = headerElement.getAttribute("expression");
                if (!StringUtils.hasText((String)expression)) continue;
                RootBeanDefinition expressionDef = new RootBeanDefinition(ExpressionFactoryBean.class);
                expressionDef.getConstructorArgumentValues().addGenericArgumentValue((Object)expression);
                headerElementsMap.put((Object)name, (Object)expressionDef);
            }
            builder.addPropertyValue("headerExpressions", (Object)headerElementsMap);
        }
        if (this.expectReply) {
            IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-channel");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"request-timeout");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-timeout");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"extract-reply-payload");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-key");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"convert-exceptions");
        } else {
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"send-timeout", (String)"requestTimeout");
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"supported-methods", (String)"supportedMethodNames");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"request-payload-type");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"view-name");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"errors-key");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"error-code");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"message-converters");
        String headerMapper = element.getAttribute("header-mapper");
        String mappedRequestHeaders = element.getAttribute("mapped-request-headers");
        String mappedResponseHeaders = element.getAttribute("mapped-response-headers");
        if (StringUtils.hasText((String)headerMapper)) {
            if (StringUtils.hasText((String)mappedRequestHeaders) || StringUtils.hasText((String)mappedResponseHeaders)) {
                parserContext.getReaderContext().error("Neither 'mappped-request-headers' or 'mapped-response-headers' attributes are allowed when a 'header-mapper' has been specified.", parserContext.extractSource((Object)element));
            }
            builder.addPropertyReference("headerMapper", headerMapper);
        } else {
            BeanDefinitionBuilder headerMapperBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.http.support.DefaultHttpHeaderMapper");
            headerMapperBuilder.setFactoryMethod("inboundMapper");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)headerMapperBuilder, (Element)element, (String)"mapped-request-headers", (String)"inboundHeaderNames");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)headerMapperBuilder, (Element)element, (String)"mapped-response-headers", (String)"outboundHeaderNames");
            builder.addPropertyValue("headerMapper", (Object)headerMapperBuilder.getBeanDefinition());
        }
    }

    private String getInputChannelAttributeName() {
        return this.expectReply ? "request-channel" : "channel";
    }

    private String createDirectChannel(Element element, ParserContext parserContext) {
        String channelId = element.getAttribute("id");
        if (!StringUtils.hasText((String)channelId)) {
            parserContext.getReaderContext().error("The channel-adapter's 'id' attribute is required when no 'channel' reference has been provided, because that 'id' would be used for the created channel.", (Object)element);
        }
        BeanDefinitionBuilder channelBuilder = BeanDefinitionBuilder.genericBeanDefinition(DirectChannel.class);
        BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)channelBuilder.getBeanDefinition(), channelId);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)parserContext.getRegistry());
        return channelId;
    }
}

