/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.outbound;

import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.MapAccessor;
import org.springframework.core.convert.ConversionService;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeConverter;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.integration.Message;
import org.springframework.integration.MessageHandlingException;
import org.springframework.integration.MessagingException;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.http.converter.SerializingHttpMessageConverter;
import org.springframework.integration.http.support.DefaultHttpHeaderMapper;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequestExecutingMessageHandler
extends AbstractReplyProducingMessageHandler {
    private final String uri;
    private volatile HttpMethod httpMethod = HttpMethod.POST;
    private volatile boolean expectReply = true;
    private volatile Class<?> expectedResponseType;
    private volatile boolean extractPayload = true;
    private volatile boolean extractPayloadExplicitlySet = false;
    private volatile String charset = "UTF-8";
    private volatile boolean transferCookies = false;
    private volatile HeaderMapper<HttpHeaders> headerMapper = DefaultHttpHeaderMapper.outboundMapper();
    private final Map<String, Expression> uriVariableExpressions = new HashMap<String, Expression>();
    private final RestTemplate restTemplate;
    private final StandardEvaluationContext evaluationContext;

    public HttpRequestExecutingMessageHandler(URI uri) {
        this(uri.toString());
    }

    public HttpRequestExecutingMessageHandler(String uri) {
        this(uri, null);
    }

    public HttpRequestExecutingMessageHandler(String uri, RestTemplate restTemplate) {
        Assert.hasText((String)uri, (String)"URI is required");
        this.restTemplate = restTemplate == null ? new RestTemplate() : restTemplate;
        this.restTemplate.getMessageConverters().add(0, new SerializingHttpMessageConverter());
        this.uri = uri;
        StandardEvaluationContext sec = new StandardEvaluationContext();
        sec.addPropertyAccessor((PropertyAccessor)new MapAccessor());
        this.evaluationContext = sec;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public void setExtractPayload(boolean extractPayload) {
        this.extractPayload = extractPayload;
        this.extractPayloadExplicitlySet = true;
    }

    public void setCharset(String charset) {
        Assert.isTrue((boolean)Charset.isSupported(charset), (String)("unsupported charset '" + charset + "'"));
        this.charset = charset;
    }

    public void setExpectReply(boolean expectReply) {
        this.expectReply = expectReply;
    }

    public void setExpectedResponseType(Class<?> expectedResponseType) {
        this.expectedResponseType = expectedResponseType;
    }

    public void setErrorHandler(ResponseErrorHandler errorHandler) {
        this.restTemplate.setErrorHandler(errorHandler);
    }

    public void setMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        this.restTemplate.setMessageConverters(messageConverters);
    }

    public void setHeaderMapper(HeaderMapper<HttpHeaders> headerMapper) {
        Assert.notNull(headerMapper, (String)"headerMapper must not be null");
        this.headerMapper = headerMapper;
    }

    public void setRequestFactory(ClientHttpRequestFactory requestFactory) {
        this.restTemplate.setRequestFactory(requestFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUriVariableExpressions(Map<String, Expression> uriVariableExpressions) {
        Map<String, Expression> map = this.uriVariableExpressions;
        synchronized (map) {
            this.uriVariableExpressions.clear();
            this.uriVariableExpressions.putAll(uriVariableExpressions);
        }
    }

    public void setTransferCookies(boolean transferCookies) {
        this.transferCookies = transferCookies;
    }

    public void onInit() {
        ConversionService conversionService;
        super.onInit();
        BeanFactory beanFactory = this.getBeanFactory();
        if (beanFactory != null) {
            this.evaluationContext.setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
        }
        if ((conversionService = this.getConversionService()) != null) {
            this.evaluationContext.setTypeConverter((TypeConverter)new StandardTypeConverter(conversionService));
        }
        if (!this.shouldIncludeRequestBody() && this.extractPayloadExplicitlySet && this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("The 'extractPayload' attribute has no meaning in the context of this handler since the provided HTTP Method is '" + this.httpMethod + "', and no request body will be sent for that method."));
        }
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        try {
            HashMap<String, Object> uriVariables = new HashMap<String, Object>();
            for (Map.Entry<String, Expression> entry : this.uriVariableExpressions.entrySet()) {
                Object value = entry.getValue().getValue((EvaluationContext)this.evaluationContext, requestMessage, String.class);
                uriVariables.put(entry.getKey(), value);
            }
            HttpEntity<?> httpRequest = this.generateHttpRequest(requestMessage);
            ResponseEntity httpResponse = this.restTemplate.exchange(this.uri, this.httpMethod, httpRequest, this.expectedResponseType, uriVariables);
            if (this.expectReply) {
                HttpHeaders httpHeaders = httpResponse.getHeaders();
                Map headers = this.headerMapper.toHeaders((Object)httpHeaders);
                if (this.transferCookies) {
                    this.doConvertSetCookie(headers);
                }
                if (httpResponse.hasBody()) {
                    Object responseBody = httpResponse.getBody();
                    MessageBuilder replyBuilder = responseBody instanceof Message ? MessageBuilder.fromMessage((Message)((Message)responseBody)) : MessageBuilder.withPayload((Object)responseBody);
                    replyBuilder.setHeader("http_statusCode", (Object)httpResponse.getStatusCode());
                    return replyBuilder.copyHeaders(headers).build();
                }
                return MessageBuilder.withPayload((Object)httpResponse.getStatusCode()).copyHeaders(headers).setHeader("http_statusCode", (Object)httpResponse.getStatusCode()).build();
            }
            return null;
        }
        catch (MessagingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageHandlingException(requestMessage, "HTTP request execution failed for URI [" + this.uri + "]", (Throwable)e);
        }
    }

    private void doConvertSetCookie(Map<String, Object> headers) {
        String keyName = null;
        for (String key : headers.keySet()) {
            if (!key.equalsIgnoreCase("Set-Cookie")) continue;
            keyName = key;
            break;
        }
        if (keyName != null) {
            Object cookies = headers.remove(keyName);
            headers.put("Cookie", cookies);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Converted Set-Cookie header to Cookie for: " + cookies));
            }
        }
    }

    private HttpEntity<?> generateHttpRequest(Message<?> message) throws Exception {
        Assert.notNull(message, (String)"message must not be null");
        return this.extractPayload ? this.createHttpEntityFromPayload(message) : this.createHttpEntityFromMessage(message);
    }

    private HttpEntity<?> createHttpEntityFromPayload(Message<?> message) {
        MultiValueMap<Object, Object> payload = message.getPayload();
        if (payload instanceof HttpEntity) {
            return (HttpEntity)payload;
        }
        HttpHeaders httpHeaders = this.mapHeaders(message);
        if (!this.shouldIncludeRequestBody()) {
            return new HttpEntity((MultiValueMap)httpHeaders);
        }
        if (httpHeaders.getContentType() == null) {
            MediaType contentType = payload instanceof String ? this.resolveContentType((String)payload, this.charset) : this.resolveContentType(payload);
            httpHeaders.setContentType(contentType);
        }
        if ((MediaType.APPLICATION_FORM_URLENCODED.equals((Object)httpHeaders.getContentType()) || MediaType.MULTIPART_FORM_DATA.equals((Object)httpHeaders.getContentType())) && !(payload instanceof MultiValueMap)) {
            payload = this.convertToMultiValueMap((Map)payload);
        }
        return new HttpEntity(payload, (MultiValueMap)httpHeaders);
    }

    private HttpEntity<?> createHttpEntityFromMessage(Message<?> message) {
        HttpHeaders httpHeaders = this.mapHeaders(message);
        if (this.shouldIncludeRequestBody()) {
            httpHeaders.setContentType(new MediaType("application", "x-java-serialized-object"));
            return new HttpEntity(message, (MultiValueMap)httpHeaders);
        }
        return new HttpEntity((MultiValueMap)httpHeaders);
    }

    protected HttpHeaders mapHeaders(Message<?> message) {
        HttpHeaders httpHeaders = new HttpHeaders();
        this.headerMapper.fromHeaders(message.getHeaders(), (Object)httpHeaders);
        return httpHeaders;
    }

    private MediaType resolveContentType(Object content) {
        MediaType contentType = null;
        if (content instanceof byte[]) {
            contentType = MediaType.APPLICATION_OCTET_STREAM;
        } else if (content instanceof Source) {
            contentType = MediaType.TEXT_XML;
        } else if (content instanceof Map && this.isFormData((Map)content)) {
            contentType = this.isMultipart((Map)content) ? MediaType.MULTIPART_FORM_DATA : MediaType.APPLICATION_FORM_URLENCODED;
        }
        if (contentType == null) {
            contentType = new MediaType("application", "x-java-serialized-object");
        }
        return contentType;
    }

    private boolean shouldIncludeRequestBody() {
        return !HttpMethod.GET.equals((Object)this.httpMethod);
    }

    private MediaType resolveContentType(String content, String charset) {
        return new MediaType("text", "plain", Charset.forName(charset));
    }

    private MultiValueMap<Object, Object> convertToMultiValueMap(Map<?, ?> simpleMap) {
        LinkedMultiValueMap multipartValueMap = new LinkedMultiValueMap();
        for (Object key : simpleMap.keySet()) {
            Object value = simpleMap.get(key);
            if (value instanceof Object[]) {
                Object[] valueArray = (Object[])value;
                value = Arrays.asList(valueArray);
            }
            if (value instanceof Collection) {
                multipartValueMap.put(key, new ArrayList((Collection)value));
                continue;
            }
            multipartValueMap.add(key, value);
        }
        return multipartValueMap;
    }

    private boolean isMultipart(Map<String, ?> map) {
        for (String key : map.keySet()) {
            Object value = map.get(key);
            if (value == null) continue;
            if (value.getClass().isArray()) {
                value = CollectionUtils.arrayToList(value);
            }
            if (value instanceof Collection) {
                Collection cValues = (Collection)value;
                for (Object cValue : cValues) {
                    if (cValue == null || cValue instanceof String) continue;
                    return true;
                }
                continue;
            }
            if (value instanceof String) continue;
            return true;
        }
        return false;
    }

    private boolean isFormData(Map<Object, ?> map) {
        for (Object key : map.keySet()) {
            if (key instanceof String) continue;
            return false;
        }
        return true;
    }
}

