/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.inbound;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.integration.http.inbound.BaseHttpInboundEndpoint;
import org.springframework.integration.http.inbound.CrossOrigin;
import org.springframework.integration.http.inbound.HttpRequestHandlingEndpointSupport;
import org.springframework.integration.http.inbound.RequestMapping;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.mvc.condition.NameValueExpression;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public final class IntegrationRequestMappingHandlerMapping
extends RequestMappingHandlerMapping
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Method HANDLE_REQUEST_METHOD = ReflectionUtils.findMethod(HttpRequestHandler.class, (String)"handleRequest", (Class[])new Class[]{HttpServletRequest.class, HttpServletResponse.class});
    private final AtomicBoolean initialized = new AtomicBoolean();

    protected boolean isHandler(Class<?> beanType) {
        return HttpRequestHandlingEndpointSupport.class.isAssignableFrom(beanType);
    }

    protected HandlerExecutionChain getHandlerExecutionChain(Object handler, HttpServletRequest request) {
        HandlerMethod handlerMethod;
        Object bean;
        if (handler instanceof HandlerMethod && (bean = (handlerMethod = (HandlerMethod)handler).getBean()) instanceof HttpRequestHandlingEndpointSupport) {
            handler = bean;
        }
        return super.getHandlerExecutionChain(handler, request);
    }

    protected CorsConfiguration getCorsConfiguration(Object handler, HttpServletRequest request) {
        if (handler instanceof HandlerMethod) {
            return super.getCorsConfiguration(handler, request);
        }
        return super.getCorsConfiguration((Object)new HandlerMethod(handler, HANDLE_REQUEST_METHOD), request);
    }

    protected void detectHandlerMethods(Object handler) {
        RequestMappingInfo mapping;
        if (handler instanceof String) {
            handler = this.getApplicationContext().getBean((String)handler);
        }
        if ((mapping = this.getMappingForEndpoint((BaseHttpInboundEndpoint)((Object)handler))) != null) {
            this.registerMapping(mapping, handler, HANDLE_REQUEST_METHOD);
        }
    }

    protected CorsConfiguration initCorsConfiguration(Object handler, Method method, RequestMappingInfo mappingInfo) {
        CrossOrigin crossOrigin = ((BaseHttpInboundEndpoint)((Object)handler)).getCrossOrigin();
        if (crossOrigin != null) {
            CorsConfiguration config = new CorsConfiguration();
            for (String string : crossOrigin.getOrigin()) {
                config.addAllowedOrigin(string);
            }
            for (String string : crossOrigin.getMethod()) {
                config.addAllowedMethod(string.name());
            }
            for (String string : crossOrigin.getAllowedHeaders()) {
                config.addAllowedHeader(string);
            }
            for (String string : crossOrigin.getExposedHeaders()) {
                config.addExposedHeader(string);
            }
            if (crossOrigin.getAllowCredentials() != null) {
                config.setAllowCredentials(crossOrigin.getAllowCredentials());
            }
            if (crossOrigin.getMaxAge() != -1L) {
                config.setMaxAge(Long.valueOf(crossOrigin.getMaxAge()));
            }
            if (CollectionUtils.isEmpty((Collection)config.getAllowedMethods())) {
                for (RequestMethod allowedMethod : mappingInfo.getMethodsCondition().getMethods()) {
                    config.addAllowedMethod(allowedMethod.name());
                }
            }
            if (CollectionUtils.isEmpty((Collection)config.getAllowedHeaders())) {
                for (NameValueExpression headerExpression : mappingInfo.getHeadersCondition().getExpressions()) {
                    if (headerExpression.isNegated()) continue;
                    config.addAllowedHeader(headerExpression.getName());
                }
            }
            return config.applyPermitDefaultValues();
        }
        return null;
    }

    private RequestMappingInfo getMappingForEndpoint(BaseHttpInboundEndpoint endpoint) {
        RequestMapping requestMapping = endpoint.getRequestMapping();
        if (ObjectUtils.isEmpty((Object[])requestMapping.getPathPatterns())) {
            return null;
        }
        HashMap<String, Object> requestMappingAttributes = new HashMap<String, Object>();
        requestMappingAttributes.put("name", endpoint.getComponentName());
        requestMappingAttributes.put("value", requestMapping.getPathPatterns());
        requestMappingAttributes.put("path", requestMapping.getPathPatterns());
        requestMappingAttributes.put("method", requestMapping.getRequestMethods());
        requestMappingAttributes.put("params", requestMapping.getParams());
        requestMappingAttributes.put("headers", requestMapping.getHeaders());
        requestMappingAttributes.put("consumes", requestMapping.getConsumes());
        requestMappingAttributes.put("produces", requestMapping.getProduces());
        org.springframework.web.bind.annotation.RequestMapping requestMappingAnnotation = (org.springframework.web.bind.annotation.RequestMapping)AnnotationUtils.synthesizeAnnotation(requestMappingAttributes, org.springframework.web.bind.annotation.RequestMapping.class, null);
        return this.createRequestMappingInfo(requestMappingAnnotation, this.getCustomTypeCondition(((Object)((Object)endpoint)).getClass()));
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext().equals(this.getApplicationContext()) && !this.initialized.getAndSet(true)) {
            super.afterPropertiesSet();
        }
    }

    public void afterPropertiesSet() {
    }
}

