/*
 * Copyright 2002-2010 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.integration.http.multipart;

import java.io.IOException;

import org.springframework.web.multipart.MultipartFile;

/**
 * {@link MultipartFileReader} implementation that reads the {@link MultipartFile}
 * content directly into a new {@link MultipartFile} instance that is not restricted
 * to the HTTP request scope.
 *
 * @author Mark Fisher
 * @since 2.0
 */
public class DefaultMultipartFileReader implements MultipartFileReader<MultipartFile> {

	public MultipartFile readMultipartFile(MultipartFile multipartFile) throws IOException {
		return new UploadedMultipartFile(multipartFile.getBytes(),
				multipartFile.getContentType(), multipartFile.getName(), multipartFile.getOriginalFilename());
	}

}
