/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.outbound;

import java.net.URI;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.http.outbound.AbstractHttpRequestExecutingMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.util.Assert;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class HttpRequestExecutingMessageHandler
extends AbstractHttpRequestExecutingMessageHandler {
    private final RestTemplate restTemplate;

    public HttpRequestExecutingMessageHandler(URI uri) {
        this((Expression)new ValueExpression((Object)uri));
    }

    public HttpRequestExecutingMessageHandler(String uri) {
        this(uri, null);
    }

    public HttpRequestExecutingMessageHandler(Expression uriExpression) {
        this(uriExpression, null);
    }

    public HttpRequestExecutingMessageHandler(String uri, RestTemplate restTemplate) {
        this((Expression)new LiteralExpression(uri), restTemplate);
        Assert.hasText((String)uri, (String)"URI is required");
    }

    public HttpRequestExecutingMessageHandler(Expression uriExpression, RestTemplate restTemplate) {
        super(uriExpression);
        this.restTemplate = restTemplate == null ? new RestTemplate() : restTemplate;
    }

    public String getComponentType() {
        return this.isExpectReply() ? "http:outbound-gateway" : "http:outbound-channel-adapter";
    }

    public void setErrorHandler(ResponseErrorHandler errorHandler) {
        this.restTemplate.setErrorHandler(errorHandler);
    }

    public void setMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        this.restTemplate.setMessageConverters(messageConverters);
    }

    public void setRequestFactory(ClientHttpRequestFactory requestFactory) {
        this.restTemplate.setRequestFactory(requestFactory);
    }

    @Override
    protected Object exchange(Supplier<URI> uriSupplier, HttpMethod httpMethod, HttpEntity<?> httpRequest, Object expectedResponseType, Message<?> requestMessage) {
        URI uri = uriSupplier.get();
        try {
            ResponseEntity httpResponse = expectedResponseType instanceof ParameterizedTypeReference ? this.restTemplate.exchange(uri, httpMethod, httpRequest, (ParameterizedTypeReference)expectedResponseType) : this.restTemplate.exchange(uri, httpMethod, httpRequest, (Class)expectedResponseType);
            return this.getReply(httpResponse);
        }
        catch (RestClientException e) {
            throw new MessageHandlingException(requestMessage, "HTTP request execution failed for URI [" + uri + "] in the [" + (Object)((Object)this) + ']', (Throwable)e);
        }
    }
}

