/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.integration.config.IntegrationConfigurationInitializer;
import org.springframework.integration.http.config.HttpContextUtils;
import org.springframework.integration.http.inbound.IntegrationRequestMappingHandlerMapping;

public class HttpIntegrationConfigurationInitializer
implements IntegrationConfigurationInitializer {
    private static final Log LOGGER = LogFactory.getLog(HttpIntegrationConfigurationInitializer.class);

    public void initialize(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (beanFactory instanceof BeanDefinitionRegistry) {
            this.registerRequestMappingHandlerMappingIfNecessary((BeanDefinitionRegistry)beanFactory);
        } else {
            LOGGER.warn((Object)"'IntegrationRequestMappingHandlerMapping' isn't registered because 'beanFactory' isn't an instance of `BeanDefinitionRegistry`.");
        }
    }

    private void registerRequestMappingHandlerMappingIfNecessary(BeanDefinitionRegistry registry) {
        if (HttpContextUtils.WEB_MVC_PRESENT && !registry.containsBeanDefinition("integrationRequestMappingHandlerMapping")) {
            BeanDefinitionBuilder requestMappingBuilder = BeanDefinitionBuilder.genericBeanDefinition(IntegrationRequestMappingHandlerMapping.class, () -> {
                IntegrationRequestMappingHandlerMapping mapping = new IntegrationRequestMappingHandlerMapping();
                mapping.setOrder(0);
                return mapping;
            });
            requestMappingBuilder.setRole(2);
            registry.registerBeanDefinition("integrationRequestMappingHandlerMapping", (BeanDefinition)requestMappingBuilder.getBeanDefinition());
        }
    }
}

