/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.integration.graph.IntegrationGraphServer;
import org.springframework.integration.http.config.EnableIntegrationGraphController;
import org.springframework.integration.http.config.HttpContextUtils;
import org.springframework.integration.http.config.WebFluxIntegrationGraphCorsConfigurer;
import org.springframework.integration.http.config.WebMvcIntegrationGraphCorsConfigurer;
import org.springframework.integration.http.management.IntegrationGraphController;

public class IntegrationGraphControllerRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final Log LOGGER = LogFactory.getLog(IntegrationGraphControllerRegistrar.class);

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        if (!HttpContextUtils.WEB_MVC_PRESENT && !HttpContextUtils.WEB_FLUX_PRESENT) {
            LOGGER.warn((Object)"The 'IntegrationGraphController' isn't registered with the application context because there is no 'org.springframework.web.servlet.DispatcherServlet' or 'org.springframework.web.reactive.DispatcherHandler' in the classpath.");
            return;
        }
        Map annotationAttributes = importingClassMetadata.getAnnotationAttributes(EnableIntegrationGraphController.class.getName());
        if (annotationAttributes == null) {
            annotationAttributes = Collections.emptyMap();
        }
        if (!registry.containsBeanDefinition("integrationGraphServer")) {
            registry.registerBeanDefinition("integrationGraphServer", (BeanDefinition)new RootBeanDefinition(IntegrationGraphServer.class, IntegrationGraphServer::new));
        }
        String path = (String)annotationAttributes.get("value");
        String[] allowedOrigins = (String[])annotationAttributes.get("allowedOrigins");
        if (allowedOrigins != null && allowedOrigins.length > 0) {
            IntegrationGraphControllerRegistrar.registerControllerCorsConfigurer(registry, path, allowedOrigins);
        }
        if (!registry.containsBeanDefinition("integrationGraphController")) {
            IntegrationGraphControllerRegistrar.registerIntegrationGraphController(registry, (String)annotationAttributes.get("value"));
        }
    }

    private static void registerIntegrationGraphController(BeanDefinitionRegistry registry, String graphControllerPath) {
        AbstractBeanDefinition controllerPropertiesPopulator = BeanDefinitionBuilder.genericBeanDefinition(GraphControllerPropertiesPopulator.class, () -> new GraphControllerPropertiesPopulator(graphControllerPath)).addConstructorArgValue((Object)graphControllerPath).setRole(2).getBeanDefinition();
        BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)controllerPropertiesPopulator, (BeanDefinitionRegistry)registry);
        AbstractBeanDefinition graphController = BeanDefinitionBuilder.rootBeanDefinition(IntegrationGraphController.class, () -> new IntegrationGraphController((IntegrationGraphServer)((BeanFactory)registry).getBean("integrationGraphServer", IntegrationGraphServer.class))).addConstructorArgReference("integrationGraphServer").getBeanDefinition();
        registry.registerBeanDefinition("integrationGraphController", (BeanDefinition)graphController);
    }

    private static void registerControllerCorsConfigurer(BeanDefinitionRegistry registry, String path, String[] allowedOrigins) {
        AbstractBeanDefinition controllerCorsConfigurer = null;
        if (HttpContextUtils.WEB_MVC_PRESENT) {
            controllerCorsConfigurer = IntegrationGraphControllerRegistrar.webMvcControllerCorsConfigurerBean(path, allowedOrigins);
        } else if (HttpContextUtils.WEB_FLUX_PRESENT) {
            controllerCorsConfigurer = IntegrationGraphControllerRegistrar.webFluxControllerCorsConfigurerBean(path, allowedOrigins);
        }
        if (controllerCorsConfigurer != null) {
            BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)controllerCorsConfigurer, (BeanDefinitionRegistry)registry);
        } else {
            LOGGER.warn((Object)"Nor Spring MVC, neither WebFlux is present to configure CORS origins for Integration Graph Controller.");
        }
    }

    private static AbstractBeanDefinition webMvcControllerCorsConfigurerBean(String path, String[] allowedOrigins) {
        return BeanDefinitionBuilder.genericBeanDefinition(WebMvcIntegrationGraphCorsConfigurer.class, () -> new WebMvcIntegrationGraphCorsConfigurer(path, allowedOrigins)).addConstructorArgValue((Object)path).addConstructorArgValue((Object)allowedOrigins).getBeanDefinition();
    }

    private static AbstractBeanDefinition webFluxControllerCorsConfigurerBean(String path, String[] allowedOrigins) {
        return BeanDefinitionBuilder.genericBeanDefinition(WebFluxIntegrationGraphCorsConfigurer.class, () -> new WebFluxIntegrationGraphCorsConfigurer(path, allowedOrigins)).addConstructorArgValue((Object)path).addConstructorArgValue((Object)allowedOrigins).getBeanDefinition();
    }

    static final class GraphControllerPropertiesPopulator
    implements BeanFactoryPostProcessor,
    EnvironmentAware {
        private final Map<String, Object> properties = new HashMap<String, Object>();

        GraphControllerPropertiesPopulator(String graphControllerPath) {
            this.properties.put("spring.integration.graph.controller.request.mapping.path", graphControllerPath);
        }

        public void setEnvironment(Environment environment) {
            ((ConfigurableEnvironment)environment).getPropertySources().addLast((PropertySource)new MapPropertySource("integrationGraphController_properties", this.properties));
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }
    }
}

