/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.multipart;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.integration.http.multipart.MultipartFileReader;
import org.springframework.integration.http.multipart.UploadedMultipartFile;
import org.springframework.web.multipart.MultipartFile;

public class FileCopyingMultipartFileReader
implements MultipartFileReader<MultipartFile> {
    private static final Log LOGGER = LogFactory.getLog(FileCopyingMultipartFileReader.class);
    private final @Nullable File directory;
    private String prefix = "si_";
    private String suffix = ".tmp";

    public FileCopyingMultipartFileReader() {
        this(null);
    }

    public FileCopyingMultipartFileReader(@Nullable File directory) {
        this.directory = directory;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    @Override
    public MultipartFile readMultipartFile(MultipartFile multipartFile) throws IOException {
        File upload = File.createTempFile(this.prefix, this.suffix, this.directory);
        multipartFile.transferTo(upload);
        UploadedMultipartFile uploadedMultipartFile = new UploadedMultipartFile(upload, multipartFile.getSize(), multipartFile.getContentType(), multipartFile.getName(), multipartFile.getOriginalFilename());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("copied uploaded file [" + multipartFile.getOriginalFilename() + "] to [" + upload.getAbsolutePath() + "]"));
        }
        return uploadedMultipartFile;
    }
}

