/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public abstract class IpAdapterParserUtils {
    static final String UDP_MULTICAST = "multicast";
    static final String MULTICAST_ADDRESS = "multicast-address";
    static final String PORT = "port";
    static final String HOST = "host";
    static final String CHECK_LENGTH = "check-length";
    static final String SO_TIMEOUT = "so-timeout";
    static final String SO_RECEIVE_BUFFER_SIZE = "so-receive-buffer-size";
    static final String SO_SEND_BUFFER_SIZE = "so-send-buffer-size";
    static final String SO_KEEP_ALIVE = "so-keep-alive";
    static final String RECEIVE_BUFFER_SIZE = "receive-buffer-size";
    static final String POOL_SIZE = "pool-size";
    static final String ACK = "acknowledge";
    static final String ACK_HOST = "ack-host";
    static final String ACK_PORT = "ack-port";
    static final String ACK_TIMEOUT = "ack-timeout";
    static final String MIN_ACKS_SUCCESS = "min-acks-for-success";
    static final String TIME_TO_LIVE = "time-to-live";
    static final String USING_NIO = "using-nio";
    static final String USING_DIRECT_BUFFERS = "using-direct-buffers";
    static final String SO_LINGER = "so-linger";
    static final String SO_TCP_NODELAY = "so-tcp-no-delay";
    static final String SO_TRAFFIC_CLASS = "so-traffic-class";
    static final String LOCAL_ADDRESS = "local-address";
    static final String TASK_EXECUTOR = "task-executor";
    static final String TCP_CONNECTION_TYPE = "type";
    static final String SERIALIZER = "serializer";
    static final String DESERIALIZER = "deserializer";
    static final String SINGLE_USE = "single-use";
    static final String TCP_CONNECTION_FACTORY = "connection-factory";
    public static final String INTERCEPTOR_FACTORY_CHAIN = "interceptor-factory-chain";
    public static final String REQUEST_TIMEOUT = "request-timeout";
    public static final String REMOTE_TIMEOUT = "remote-timeout";
    public static final String REMOTE_TIMEOUT_EXPRESSION = "remote-timeout-expression";
    public static final String REPLY_TIMEOUT = "reply-timeout";
    public static final String REPLY_CHANNEL = "reply-channel";
    public static final String LOOKUP_HOST = "lookup-host";
    public static final String APPLY_SEQUENCE = "apply-sequence";
    public static final String CLIENT_MODE = "client-mode";
    public static final String RETRY_INTERVAL = "retry-interval";
    public static final String SCHEDULER = "scheduler";
    public static final String SSL_CONTEXT_SUPPORT = "ssl-context-support";
    public static final String SOCKET_SUPPORT = "socket-support";
    public static final String NIO_CONNECTION_SUPPORT = "nio-connection-support";
    public static final String NET_CONNECTION_SUPPORT = "net-connection-support";
    public static final String SOCKET_FACTORY_SUPPORT = "socket-factory-support";
    public static final String BACKLOG = "backlog";
    public static final String MAPPER = "mapper";
    public static final String READ_DELAY = "read-delay";
    public static final String SSL_HANDSHAKE_TIMEOUT = "ssl-handshake-timeout";
    public static final String CONNECT_TIMEOUT = "connect-timeout";
    public static final String UDP_SOCKET_CUSTOMIZER = "socket-customizer";

    private IpAdapterParserUtils() {
    }

    public static void addConstructorValueIfAttributeDefined(BeanDefinitionBuilder builder, Element element, String attributeName) {
        String attributeValue = element.getAttribute(attributeName);
        if (StringUtils.hasText((String)attributeValue)) {
            builder.addConstructorArgValue((Object)attributeValue);
        }
    }

    public static void addDestinationConfigToConstructor(Element element, BeanDefinitionBuilder builder, ParserContext parserContext) {
        String destinationExpression = element.getAttribute("destination-expression");
        if (StringUtils.hasText((String)destinationExpression)) {
            IpAdapterParserUtils.addDestinationExpressionToConstructor(destinationExpression, element, builder, parserContext);
        } else {
            IpAdapterParserUtils.addHostAndPortToConstructor(element, builder, parserContext);
        }
    }

    private static void addDestinationExpressionToConstructor(String destinationExpression, Element element, BeanDefinitionBuilder builder, ParserContext parserContext) {
        String host = element.getAttribute(HOST);
        String port = element.getAttribute(PORT);
        if (StringUtils.hasText((String)host) || StringUtils.hasText((String)port)) {
            parserContext.getReaderContext().error("The 'destination-expression' is mutually exclusive with 'host/port' pair.", (Object)element);
        }
        builder.addConstructorArgValue((Object)destinationExpression);
    }

    private static void addHostAndPortToConstructor(Element element, BeanDefinitionBuilder builder, ParserContext parserContext) {
        String host = element.getAttribute(HOST);
        if (!StringUtils.hasText((String)host)) {
            parserContext.getReaderContext().error("host is required for IP outbound channel adapters", (Object)element);
        }
        builder.addConstructorArgValue((Object)host);
        String port = IpAdapterParserUtils.getPort(element, parserContext);
        builder.addConstructorArgValue((Object)port);
    }

    static String getPort(Element element, ParserContext parserContext) {
        String port = element.getAttribute(PORT);
        if (!StringUtils.hasText((String)port)) {
            parserContext.getReaderContext().error("port is required for IP channel adapters", (Object)element);
        }
        return port;
    }

    static String getMulticast(Element element) {
        String multicast = element.getAttribute(UDP_MULTICAST);
        if (!StringUtils.hasText((String)multicast)) {
            multicast = "false";
        }
        return multicast;
    }

    static void addCommonSocketOptions(BeanDefinitionBuilder builder, Element element) {
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)SO_TIMEOUT);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)SO_RECEIVE_BUFFER_SIZE);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)SO_SEND_BUFFER_SIZE);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)LOCAL_ADDRESS);
    }
}

