/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms.config;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractPollingInboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.jms.JmsDestinationPollingSource;
import org.springframework.integration.jms.config.JmsAdapterParserUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class JmsInboundChannelAdapterParser
extends AbstractPollingInboundChannelAdapterParser {
    protected boolean shouldGenerateId() {
        return false;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected BeanMetadataElement parseSource(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(JmsDestinationPollingSource.class);
        String componentName = this.resolveId(element, builder.getBeanDefinition(), parserContext);
        if (StringUtils.hasText((String)componentName)) {
            builder.addPropertyValue("componentName", (Object)componentName);
        }
        String jmsTemplate = element.getAttribute("jms-template");
        String destination = element.getAttribute("destination");
        String destinationName = element.getAttribute("destination-name");
        String headerMapper = element.getAttribute("header-mapper");
        boolean hasJmsTemplate = StringUtils.hasText((String)jmsTemplate);
        boolean hasDestinationRef = StringUtils.hasText((String)destination);
        boolean hasDestinationName = StringUtils.hasText((String)destinationName);
        if (hasJmsTemplate) {
            JmsAdapterParserUtils.verifyNoJmsTemplateAttributes(element, parserContext);
            builder.addConstructorArgReference(jmsTemplate);
        } else {
            builder.addConstructorArgValue((Object)JmsAdapterParserUtils.parseJmsTemplateBeanDefinition(element, parserContext));
        }
        if (hasDestinationRef || hasDestinationName) {
            if (hasDestinationRef) {
                if (hasDestinationName) {
                    parserContext.getReaderContext().error("The 'destination-name' and 'destination' attributes are mutually exclusive.", parserContext.extractSource((Object)element));
                }
                builder.addPropertyReference("destination", destination);
            } else if (hasDestinationName) {
                builder.addPropertyValue("destinationName", (Object)destinationName);
            }
        } else if (!hasJmsTemplate) {
            parserContext.getReaderContext().error("either a 'jms-template' or one of 'destination' or 'destination-name' attributes must be provided for a polling JMS adapter", parserContext.extractSource((Object)element));
        }
        if (StringUtils.hasText((String)headerMapper)) {
            builder.addPropertyReference("headerMapper", headerMapper);
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"selector", (String)"messageSelector");
        return builder.getBeanDefinition();
    }
}

