/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms.dsl;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.integration.dsl.ComponentsRegistration;
import org.springframework.integration.dsl.MessageSourceSpec;
import org.springframework.integration.jms.JmsDestinationPollingSource;
import org.springframework.integration.jms.JmsHeaderMapper;
import org.springframework.integration.jms.dsl.JmsTemplateSpec;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.util.Assert;

public class JmsInboundChannelAdapterSpec<S extends JmsInboundChannelAdapterSpec<S>>
extends MessageSourceSpec<S, JmsDestinationPollingSource> {
    protected final JmsTemplateSpec jmsTemplateSpec = new JmsTemplateSpec();

    protected JmsInboundChannelAdapterSpec(JmsTemplate jmsTemplate) {
        this.target = new JmsDestinationPollingSource(jmsTemplate);
    }

    private JmsInboundChannelAdapterSpec(ConnectionFactory connectionFactory) {
        this.target = new JmsDestinationPollingSource((JmsTemplate)((JmsTemplateSpec)((Object)this.jmsTemplateSpec.connectionFactory(connectionFactory))).get());
    }

    public S messageSelector(String messageSelector) {
        ((JmsDestinationPollingSource)((Object)this.target)).setMessageSelector(messageSelector);
        return (S)((Object)((JmsInboundChannelAdapterSpec)this._this()));
    }

    public S headerMapper(JmsHeaderMapper headerMapper) {
        ((JmsDestinationPollingSource)((Object)this.target)).setHeaderMapper(headerMapper);
        return (S)((Object)((JmsInboundChannelAdapterSpec)this._this()));
    }

    public S destination(Destination destination) {
        ((JmsDestinationPollingSource)((Object)this.target)).setDestination(destination);
        return (S)((Object)((JmsInboundChannelAdapterSpec)this._this()));
    }

    public S destination(String destination) {
        ((JmsDestinationPollingSource)((Object)this.target)).setDestinationName(destination);
        return (S)((Object)((JmsInboundChannelAdapterSpec)this._this()));
    }

    public static class JmsInboundChannelSpecTemplateAware
    extends JmsInboundChannelAdapterSpec<JmsInboundChannelSpecTemplateAware>
    implements ComponentsRegistration {
        protected JmsInboundChannelSpecTemplateAware(ConnectionFactory connectionFactory) {
            super(connectionFactory);
        }

        public JmsInboundChannelSpecTemplateAware configureJmsTemplate(Consumer<JmsTemplateSpec> configurer) {
            Assert.notNull(configurer, (String)"'configurer' must not be null");
            configurer.accept(this.jmsTemplateSpec);
            return (JmsInboundChannelSpecTemplateAware)this._this();
        }

        public Map<Object, String> getComponentsToRegister() {
            return Collections.singletonMap(this.jmsTemplateSpec.get(), this.jmsTemplateSpec.getId());
        }
    }
}

