/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms.dsl;

import jakarta.jms.Destination;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.integration.dsl.ComponentsRegistration;
import org.springframework.integration.dsl.MessageProducerSpec;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.jms.ChannelPublishingJmsMessageListener;
import org.springframework.integration.jms.JmsHeaderMapper;
import org.springframework.integration.jms.JmsMessageDrivenEndpoint;
import org.springframework.integration.jms.dsl.JmsListenerContainerSpec;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.util.Assert;

public class JmsMessageDrivenChannelAdapterSpec<S extends JmsMessageDrivenChannelAdapterSpec<S>>
extends MessageProducerSpec<S, JmsMessageDrivenEndpoint> {
    protected JmsMessageDrivenChannelAdapterSpec(AbstractMessageListenerContainer listenerContainer) {
        super((MessageProducerSupport)new JmsMessageDrivenEndpoint(listenerContainer, new ChannelPublishingJmsMessageListener()));
        ((JmsMessageDrivenEndpoint)((Object)this.target)).getListener().setExpectReply(false);
    }

    public S jmsMessageConverter(MessageConverter messageConverter) {
        ((JmsMessageDrivenEndpoint)((Object)this.target)).getListener().setMessageConverter(messageConverter);
        return (S)((Object)((JmsMessageDrivenChannelAdapterSpec)this._this()));
    }

    public S headerMapper(JmsHeaderMapper headerMapper) {
        ((JmsMessageDrivenEndpoint)((Object)this.target)).getListener().setHeaderMapper(headerMapper);
        return (S)((Object)((JmsMessageDrivenChannelAdapterSpec)this._this()));
    }

    public S extractPayload(boolean extractRequestPayload) {
        ((JmsMessageDrivenEndpoint)((Object)this.target)).getListener().setExtractRequestPayload(extractRequestPayload);
        return (S)((Object)((JmsMessageDrivenChannelAdapterSpec)this._this()));
    }

    public S shutdownContainerOnStop(boolean shutdown) {
        ((JmsMessageDrivenEndpoint)((Object)this.target)).setShutdownContainerOnStop(shutdown);
        return (S)((Object)((JmsMessageDrivenChannelAdapterSpec)this._this()));
    }

    public static class JmsMessageDrivenChannelAdapterListenerContainerSpec<S extends JmsListenerContainerSpec<S, C>, C extends AbstractMessageListenerContainer>
    extends JmsMessageDrivenChannelAdapterSpec<JmsMessageDrivenChannelAdapterListenerContainerSpec<S, C>>
    implements ComponentsRegistration {
        private final S spec;

        protected JmsMessageDrivenChannelAdapterListenerContainerSpec(S spec) {
            super((AbstractMessageListenerContainer)spec.get());
            this.spec = spec;
            ((AbstractMessageListenerContainer)this.spec.get()).setAutoStartup(false);
        }

        public JmsMessageDrivenChannelAdapterListenerContainerSpec<S, C> destination(Destination destination) {
            ((JmsListenerContainerSpec)((Object)this.spec)).destination(destination);
            return (JmsMessageDrivenChannelAdapterListenerContainerSpec)this._this();
        }

        public JmsMessageDrivenChannelAdapterListenerContainerSpec<S, C> destination(String destinationName) {
            ((JmsListenerContainerSpec)((Object)this.spec)).destination(destinationName);
            return (JmsMessageDrivenChannelAdapterListenerContainerSpec)this._this();
        }

        public JmsMessageDrivenChannelAdapterListenerContainerSpec<S, C> configureListenerContainer(Consumer<S> configurer) {
            Assert.notNull(configurer, (String)"'configurer' must not be null");
            configurer.accept(this.spec);
            return (JmsMessageDrivenChannelAdapterListenerContainerSpec)this._this();
        }

        public Map<Object, String> getComponentsToRegister() {
            return Collections.singletonMap(this.spec.get(), this.spec.getId());
        }
    }
}

