/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import jakarta.jms.Destination;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.log.LogAccessor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.integration.jms.DefaultJmsHeaderMapper;
import org.springframework.integration.jms.JmsHeaderMapper;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.integration.support.management.TrackableComponent;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.jms.listener.SessionAwareMessageListener;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.SimpleMessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.jms.support.destination.DynamicDestinationResolver;
import org.springframework.lang.Nullable;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.util.Assert;

public class ChannelPublishingJmsMessageListener
implements SessionAwareMessageListener<Message>,
InitializingBean,
TrackableComponent,
BeanFactoryAware {
    protected final LogAccessor logger = new LogAccessor(this.getClass());
    private final GatewayDelegate gatewayDelegate = new GatewayDelegate();
    private boolean expectReply;
    private MessageConverter messageConverter = new SimpleMessageConverter();
    private boolean extractRequestPayload = true;
    private boolean extractReplyPayload = true;
    private Object defaultReplyDestination;
    private String correlationKey;
    private long replyTimeToLive = 0L;
    private int replyPriority = 4;
    private int replyDeliveryMode = 2;
    private boolean explicitQosEnabledForReplies;
    private DestinationResolver destinationResolver = new DynamicDestinationResolver();
    private Expression replyToExpression;
    private JmsHeaderMapper headerMapper = new DefaultJmsHeaderMapper();
    private BeanFactory beanFactory;
    private MessageBuilderFactory messageBuilderFactory = new DefaultMessageBuilderFactory();
    private StandardEvaluationContext evaluationContext;

    public void setExpectReply(boolean expectReply) {
        this.expectReply = expectReply;
    }

    public void setComponentName(String componentName) {
        this.gatewayDelegate.setComponentName(componentName);
    }

    public void setRequestChannel(MessageChannel requestChannel) {
        this.gatewayDelegate.setRequestChannel(requestChannel);
    }

    public void setRequestChannelName(String requestChannelName) {
        this.gatewayDelegate.setRequestChannelName(requestChannelName);
    }

    public void setReplyChannel(MessageChannel replyChannel) {
        this.gatewayDelegate.setReplyChannel(replyChannel);
    }

    public void setReplyChannelName(String replyChannelName) {
        this.gatewayDelegate.setReplyChannelName(replyChannelName);
    }

    public void setErrorChannel(MessageChannel errorChannel) {
        this.gatewayDelegate.setErrorChannel(errorChannel);
    }

    public void setErrorChannelName(String errorChannelName) {
        this.gatewayDelegate.setErrorChannelName(errorChannelName);
    }

    public void setRequestTimeout(long requestTimeout) {
        this.gatewayDelegate.setRequestTimeout(requestTimeout);
    }

    public void setReplyTimeout(long replyTimeout) {
        this.gatewayDelegate.setReplyTimeout(replyTimeout);
    }

    public void setErrorOnTimeout(boolean errorOnTimeout) {
        this.gatewayDelegate.setErrorOnTimeout(errorOnTimeout);
    }

    public void setShouldTrack(boolean shouldTrack) {
        this.gatewayDelegate.setShouldTrack(shouldTrack);
    }

    public String getComponentName() {
        return this.gatewayDelegate.getComponentName();
    }

    public String getComponentType() {
        return this.gatewayDelegate.getComponentType();
    }

    public void setDefaultReplyDestination(Destination defaultReplyDestination) {
        this.defaultReplyDestination = defaultReplyDestination;
    }

    public void setDefaultReplyQueueName(String destinationName) {
        this.defaultReplyDestination = new DestinationNameHolder(destinationName, false);
    }

    public void setDefaultReplyTopicName(String destinationName) {
        this.defaultReplyDestination = new DestinationNameHolder(destinationName, true);
    }

    public void setReplyTimeToLive(long replyTimeToLive) {
        this.replyTimeToLive = replyTimeToLive;
    }

    public void setReplyPriority(int replyPriority) {
        this.replyPriority = replyPriority;
    }

    public void setReplyDeliveryPersistent(boolean replyDeliveryPersistent) {
        this.replyDeliveryMode = replyDeliveryPersistent ? 2 : 1;
    }

    public void setCorrelationKey(String correlationKey) {
        this.correlationKey = correlationKey;
    }

    public void setExplicitQosEnabledForReplies(boolean explicitQosEnabledForReplies) {
        this.explicitQosEnabledForReplies = explicitQosEnabledForReplies;
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        Assert.notNull((Object)destinationResolver, (String)"destinationResolver must not be null");
        this.destinationResolver = destinationResolver;
    }

    public void setReplyToExpression(Expression replyToExpression) {
        this.replyToExpression = replyToExpression;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public void setHeaderMapper(JmsHeaderMapper headerMapper) {
        this.headerMapper = headerMapper;
    }

    public void setExtractRequestPayload(boolean extractRequestPayload) {
        this.extractRequestPayload = extractRequestPayload;
    }

    public void setExtractReplyPayload(boolean extractReplyPayload) {
        this.extractReplyPayload = extractReplyPayload;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void onMessage(Message jmsMessage, Session session) throws JMSException {
        org.springframework.messaging.Message requestMessage;
        try {
            Object result;
            if (this.extractRequestPayload) {
                result = this.messageConverter.fromMessage(jmsMessage);
                this.logger.debug(() -> "converted JMS Message [" + jmsMessage + "] to integration Message payload [" + result + "]");
            } else {
                result = jmsMessage;
            }
            Map headers = this.headerMapper.toHeaders(jmsMessage);
            requestMessage = result instanceof org.springframework.messaging.Message ? this.messageBuilderFactory.fromMessage((org.springframework.messaging.Message)result).copyHeaders(headers).build() : this.messageBuilderFactory.withPayload(result).copyHeaders(headers).build();
        }
        catch (RuntimeException e) {
            MessageChannel errorChannel = this.gatewayDelegate.getErrorChannel();
            if (errorChannel == null) {
                throw e;
            }
            this.gatewayDelegate.getMessagingTemplate().send((Object)errorChannel, (org.springframework.messaging.Message)this.gatewayDelegate.buildErrorMessage((Throwable)new MessagingException("Inbound conversion failed for: " + jmsMessage, (Throwable)e)));
            return;
        }
        if (!this.expectReply) {
            this.gatewayDelegate.send(requestMessage);
        } else {
            org.springframework.messaging.Message<?> replyMessage = this.gatewayDelegate.sendAndReceiveMessage(requestMessage);
            if (replyMessage != null) {
                Destination destination = this.getReplyDestination(jmsMessage, session);
                this.logger.debug(() -> "Reply destination: " + destination);
                Object replyResult = this.extractReplyPayload ? replyMessage.getPayload() : replyMessage;
                try {
                    Message jmsReply = this.messageConverter.toMessage(replyResult, session);
                    this.headerMapper.fromHeaders(replyMessage.getHeaders(), jmsReply);
                    this.copyCorrelationIdFromRequestToReply(jmsMessage, jmsReply);
                    this.sendReply(jmsReply, destination, session);
                }
                catch (RuntimeException ex) {
                    this.logger.error((Throwable)ex, () -> "Failed to generate JMS Reply Message from: " + replyResult);
                    throw ex;
                }
            } else {
                this.logger.debug((CharSequence)"expected a reply but none was received");
            }
        }
    }

    public void afterPropertiesSet() {
        if (this.beanFactory != null) {
            this.gatewayDelegate.setBeanFactory(this.beanFactory);
        }
        this.gatewayDelegate.afterPropertiesSet();
        this.messageBuilderFactory = IntegrationUtils.getMessageBuilderFactory((BeanFactory)this.beanFactory);
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.beanFactory);
    }

    protected void start() {
        this.gatewayDelegate.start();
    }

    protected void stop() {
        this.gatewayDelegate.stop();
    }

    private void copyCorrelationIdFromRequestToReply(Message requestMessage, Message replyMessage) throws JMSException {
        if (this.correlationKey != null) {
            if (this.correlationKey.equals("JMSCorrelationID")) {
                replyMessage.setJMSCorrelationID(requestMessage.getJMSCorrelationID());
            } else {
                String value = requestMessage.getStringProperty(this.correlationKey);
                if (value != null) {
                    replyMessage.setStringProperty(this.correlationKey, value);
                } else {
                    this.logger.warn(() -> "No property value available on request Message for correlationKey '" + this.correlationKey + "'");
                }
            }
        } else if (replyMessage.getJMSCorrelationID() == null) {
            replyMessage.setJMSCorrelationID(requestMessage.getJMSMessageID());
        }
    }

    private Destination getReplyDestination(Message request, Session session) throws JMSException {
        Destination replyTo = this.resolveReplyTo(request, session);
        if (replyTo == null && (replyTo = this.resolveDefaultReplyDestination(session)) == null) {
            throw new InvalidDestinationException("Cannot determine reply destination: Request message does not contain reply-to destination, and no default reply destination set.");
        }
        return replyTo;
    }

    @Nullable
    private Destination resolveReplyTo(Message request, Session session) throws JMSException {
        Destination replyTo = request.getJMSReplyTo();
        if (replyTo == null && this.replyToExpression != null) {
            Object replyToValue = this.replyToExpression.getValue((EvaluationContext)this.evaluationContext, (Object)request);
            if (replyToValue instanceof Destination) {
                Destination destination = (Destination)replyToValue;
                return destination;
            }
            if (replyToValue instanceof String) {
                String destinationName = (String)replyToValue;
                return this.destinationResolver.resolveDestinationName(session, destinationName, false);
            }
        }
        return replyTo;
    }

    private Destination resolveDefaultReplyDestination(Session session) throws JMSException {
        if (this.defaultReplyDestination instanceof Destination) {
            return (Destination)this.defaultReplyDestination;
        }
        Object object = this.defaultReplyDestination;
        if (object instanceof DestinationNameHolder) {
            DestinationNameHolder nameHolder = (DestinationNameHolder)object;
            return this.destinationResolver.resolveDestinationName(session, nameHolder.name, nameHolder.isTopic);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendReply(Message replyMessage, Destination destination, Session session) throws JMSException {
        MessageProducer producer = session.createProducer(destination);
        try {
            if (this.explicitQosEnabledForReplies) {
                producer.send(replyMessage, this.replyDeliveryMode, this.replyPriority, this.replyTimeToLive);
            } else {
                producer.send(replyMessage);
            }
        }
        finally {
            JmsUtils.closeMessageProducer((MessageProducer)producer);
        }
    }

    private class GatewayDelegate
    extends MessagingGatewaySupport {
        GatewayDelegate() {
        }

        protected void send(Object request) {
            super.send(request);
        }

        protected org.springframework.messaging.Message<?> sendAndReceiveMessage(Object request) {
            return super.sendAndReceiveMessage(request);
        }

        protected ErrorMessage buildErrorMessage(Throwable throwable) {
            return super.buildErrorMessage(null, throwable);
        }

        protected MessagingTemplate getMessagingTemplate() {
            return this.messagingTemplate;
        }

        public String getComponentType() {
            if (ChannelPublishingJmsMessageListener.this.expectReply) {
                return "jms:inbound-gateway";
            }
            return "jms:message-driven-channel-adapter";
        }
    }

    private record DestinationNameHolder(String name, boolean isTopic) {
    }
}

