/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jmx;

import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.Message;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.util.Assert;

public class NotificationListeningMessageProducer
extends MessageProducerSupport
implements NotificationListener {
    private final Log logger = LogFactory.getLog(this.getClass());
    private volatile MBeanServer server;
    private volatile ObjectName objectName;
    private volatile NotificationFilter filter;
    private volatile Object handback;

    public void setServer(MBeanServer server) {
        this.server = server;
    }

    public void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
    }

    public void setFilter(NotificationFilter filter) {
        this.filter = filter;
    }

    public void setHandback(Object handback) {
        this.handback = handback;
    }

    public void handleNotification(Notification notification, Object handback) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("received notification: " + notification + ", and handback: " + handback));
        }
        MessageBuilder builder = MessageBuilder.withPayload((Object)notification);
        if (handback != null) {
            builder.setHeader("jmx_notificationHandback", handback);
        }
        Message message = builder.build();
        this.sendMessage(message);
    }

    public String getComponentType() {
        return "jmx:notification-listening-channel-adapter";
    }

    protected void doStart() {
        try {
            Assert.notNull((Object)this.server, (String)"MBeanServer is required.");
            Assert.notNull((Object)this.objectName, (String)"An ObjectName is required.");
            this.server.addNotificationListener(this.objectName, this, this.filter, this.handback);
        }
        catch (InstanceNotFoundException e) {
            throw new IllegalStateException("Failed to find MBean instance.", e);
        }
    }

    protected void doStop() {
        if (this.server != null && this.objectName != null) {
            try {
                this.server.removeNotificationListener(this.objectName, this, this.filter, this.handback);
            }
            catch (InstanceNotFoundException e) {
                throw new IllegalStateException("Failed to find MBean instance.", e);
            }
            catch (ListenerNotFoundException e) {
                throw new IllegalStateException("Failed to find NotificationListener.", e);
            }
        }
    }
}

