/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jpa.config.xml;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.jpa.config.xml.AbstractJpaOutboundGatewayParser;
import org.springframework.integration.jpa.config.xml.JpaParserUtils;
import org.springframework.integration.jpa.support.OutboundGatewayType;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class RetrievingJpaOutboundGatewayParser
extends AbstractJpaOutboundGatewayParser {
    @Override
    protected BeanDefinitionBuilder parseHandler(Element gatewayElement, ParserContext parserContext) {
        BeanDefinition maxResultsExpression;
        BeanDefinitionBuilder jpaOutboundGatewayBuilder = super.parseHandler(gatewayElement, parserContext);
        BeanDefinitionBuilder jpaExecutorBuilder = JpaParserUtils.getOutboundGatewayJpaExecutorBuilder(gatewayElement, parserContext);
        BeanDefinition firstResultExpression = IntegrationNamespaceUtils.createExpressionDefinitionFromValueOrExpression((String)"first-result", (String)"first-result-expression", (ParserContext)parserContext, (Element)gatewayElement, (boolean)false);
        if (firstResultExpression != null) {
            jpaExecutorBuilder.addPropertyValue("firstResultExpression", (Object)firstResultExpression);
        }
        String maxNumberOfResults = gatewayElement.getAttribute("max-number-of-results");
        boolean hasMaxNumberOfResults = StringUtils.hasText((String)maxNumberOfResults);
        String maxResults = gatewayElement.getAttribute("max-results");
        boolean hasMaxResults = StringUtils.hasText((String)maxResults);
        if (hasMaxNumberOfResults) {
            parserContext.getReaderContext().warning("'max-number-of-results' is deprecated in favor of 'max-results'", (Object)gatewayElement);
            if (hasMaxResults) {
                parserContext.getReaderContext().error("'max-number-of-results' and 'max-results' are mutually exclusive", (Object)gatewayElement);
            } else {
                gatewayElement.setAttribute("max-results", maxNumberOfResults);
            }
        }
        if ((maxResultsExpression = IntegrationNamespaceUtils.createExpressionDefinitionFromValueOrExpression((String)"max-results", (String)"max-results-expression", (ParserContext)parserContext, (Element)gatewayElement, (boolean)false)) != null) {
            jpaExecutorBuilder.addPropertyValue("maxResultsExpression", (Object)maxResultsExpression);
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)jpaExecutorBuilder, (Element)gatewayElement, (String)"delete-after-poll");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)jpaExecutorBuilder, (Element)gatewayElement, (String)"flush-after-delete", (String)"flush");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)jpaExecutorBuilder, (Element)gatewayElement, (String)"delete-in-batch");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)jpaExecutorBuilder, (Element)gatewayElement, (String)"expect-single-result");
        AbstractBeanDefinition jpaExecutorBuilderBeanDefinition = jpaExecutorBuilder.getBeanDefinition();
        String gatewayId = this.resolveId(gatewayElement, jpaOutboundGatewayBuilder.getRawBeanDefinition(), parserContext);
        String jpaExecutorBeanName = gatewayId + ".jpaExecutor";
        parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)jpaExecutorBuilderBeanDefinition, jpaExecutorBeanName));
        jpaOutboundGatewayBuilder.addConstructorArgReference(jpaExecutorBeanName);
        jpaOutboundGatewayBuilder.addPropertyValue("gatewayType", (Object)OutboundGatewayType.RETRIEVING);
        return jpaOutboundGatewayBuilder;
    }
}

