/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.listener;

import kafka.serializer.Decoder;
import org.springframework.integration.kafka.core.KafkaMessage;
import org.springframework.integration.kafka.core.KafkaMessageMetadata;
import org.springframework.integration.kafka.listener.AcknowledgingMessageListener;
import org.springframework.integration.kafka.listener.Acknowledgment;
import org.springframework.integration.kafka.util.MessageUtils;

public abstract class AbstractDecodingAcknowledgingMessageListener<K, P>
implements AcknowledgingMessageListener {
    private final Decoder<K> keyDecoder;
    private final Decoder<P> payloadDecoder;

    public AbstractDecodingAcknowledgingMessageListener(Decoder<K> keyDecoder, Decoder<P> payloadDecoder) {
        this.keyDecoder = keyDecoder;
        this.payloadDecoder = payloadDecoder;
    }

    @Override
    public final void onMessage(KafkaMessage message, Acknowledgment acknowledgment) {
        this.doOnMessage(MessageUtils.decodeKey(message, this.keyDecoder), MessageUtils.decodePayload(message, this.payloadDecoder), message.getMetadata(), acknowledgment);
    }

    public abstract void doOnMessage(K var1, P var2, KafkaMessageMetadata var3, Acknowledgment var4);
}

