/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.listener;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.Map;
import org.springframework.integration.kafka.core.ConnectionFactory;
import org.springframework.integration.kafka.core.Partition;
import org.springframework.integration.kafka.listener.AbstractOffsetManager;
import org.springframework.integration.metadata.MetadataStore;
import org.springframework.integration.metadata.SimpleMetadataStore;

public class MetadataStoreOffsetManager
extends AbstractOffsetManager {
    private MetadataStore metadataStore = new SimpleMetadataStore();

    public MetadataStoreOffsetManager(ConnectionFactory connectionFactory) {
        super(connectionFactory);
    }

    public MetadataStoreOffsetManager(ConnectionFactory connectionFactory, Map<Partition, Long> initialOffsets) {
        super(connectionFactory, initialOffsets);
    }

    public void setMetadataStore(MetadataStore metadataStore) {
        this.metadataStore = metadataStore;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        if (this.metadataStore instanceof Closeable) {
            ((Closeable)this.metadataStore).close();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.metadataStore instanceof Flushable) {
            ((Flushable)this.metadataStore).flush();
        }
    }

    @Override
    protected void doUpdateOffset(Partition partition, long offset) {
        this.metadataStore.put(this.generateKey(partition), Long.toString(offset));
    }

    @Override
    protected void doRemoveOffset(Partition partition) {
        this.metadataStore.remove(this.generateKey(partition));
    }

    @Override
    protected Long doGetOffset(Partition partition) {
        String storedOffsetValueAsString = this.metadataStore.get(this.generateKey(partition));
        Long storedOffsetValue = null;
        if (storedOffsetValueAsString != null) {
            try {
                storedOffsetValue = Long.parseLong(storedOffsetValueAsString);
            }
            catch (NumberFormatException e) {
                this.log.warn((Object)("Invalid value: " + storedOffsetValueAsString));
            }
        }
        return storedOffsetValue;
    }

    public String generateKey(Partition partition) {
        return partition.getTopic() + ":" + partition.getId() + ":" + this.getConsumerId();
    }
}

