/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail;

import javax.mail.FolderClosedException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.mail.ImapMailReceiver;
import org.springframework.integration.message.MessageBuilder;
import org.springframework.util.Assert;

public class ImapIdleChannelAdapter
extends MessageProducerSupport {
    private final IdleTask idleTask = new IdleTask();
    private volatile boolean shouldReconnectAutomatically = true;
    private volatile TaskExecutor taskExecutor;
    private final ImapMailReceiver mailReceiver;

    public ImapIdleChannelAdapter(ImapMailReceiver mailReceiver) {
        Assert.notNull((Object)mailReceiver, (String)"mailReceiver must not be null");
        this.mailReceiver = mailReceiver;
    }

    public void setShouldReconnectAutomatically(boolean shouldReconnectAutomatically) {
        this.shouldReconnectAutomatically = shouldReconnectAutomatically;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    protected void handleMailMessagingException(MessagingException e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)"error occurred in idle task", (Throwable)e);
        }
    }

    protected void doStart() {
        if (this.taskExecutor == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("No TaskExecutor has been provided, will use a [" + SimpleAsyncTaskExecutor.class + "] as the default."));
            }
            this.taskExecutor = new SimpleAsyncTaskExecutor();
        }
        this.taskExecutor.execute((Runnable)this.idleTask);
    }

    protected void doStop() {
        this.idleTask.interrupt();
    }

    private class IdleTask
    implements Runnable {
        private volatile Thread thread;

        private IdleTask() {
        }

        public synchronized void interrupt() {
            if (this.thread != null) {
                this.thread.interrupt();
            } else if (((IntegrationObjectSupport)ImapIdleChannelAdapter.this).logger.isInfoEnabled()) {
                ((IntegrationObjectSupport)ImapIdleChannelAdapter.this).logger.info((Object)"monitor is not running, cannot interrupt");
            }
        }

        public void run() {
            this.thread = Thread.currentThread();
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    if (((IntegrationObjectSupport)ImapIdleChannelAdapter.this).logger.isDebugEnabled()) {
                        ((IntegrationObjectSupport)ImapIdleChannelAdapter.this).logger.debug((Object)"waiting for mail");
                    }
                    ImapIdleChannelAdapter.this.mailReceiver.waitForNewMessages();
                    Message[] mailMessages = ImapIdleChannelAdapter.this.mailReceiver.receive();
                    if (((IntegrationObjectSupport)ImapIdleChannelAdapter.this).logger.isDebugEnabled()) {
                        ((IntegrationObjectSupport)ImapIdleChannelAdapter.this).logger.debug((Object)("received " + mailMessages.length + " mail messages"));
                    }
                    Message[] messageArray = mailMessages;
                    int n = mailMessages.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Message mailMessage = messageArray[n2];
                        MimeMessage copied = new MimeMessage((MimeMessage)mailMessage);
                        ImapIdleChannelAdapter.this.sendMessage(MessageBuilder.withPayload((Object)copied).build());
                        ++n2;
                    }
                }
                catch (MessagingException e) {
                    if (e instanceof FolderClosedException && ImapIdleChannelAdapter.this.shouldReconnectAutomatically) continue;
                    ImapIdleChannelAdapter.this.handleMailMessagingException(e);
                    return;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }
}

