/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail;

import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.IMAPMessage;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.event.MessageCountAdapter;
import javax.mail.event.MessageCountEvent;
import javax.mail.event.MessageCountListener;
import javax.mail.search.AndTerm;
import javax.mail.search.FlagTerm;
import javax.mail.search.NotTerm;
import javax.mail.search.SearchTerm;
import org.springframework.integration.mail.AbstractMailReceiver;
import org.springframework.integration.mail.SearchTermStrategy;
import org.springframework.util.Assert;

public class ImapMailReceiver
extends AbstractMailReceiver {
    private volatile boolean shouldMarkMessagesAsRead = true;
    private volatile SearchTermStrategy searchTermStrategy = new DefaultSearchTermStrategy();
    private final MessageCountListener messageCountListener = new SimpleMessageCountListener();

    public ImapMailReceiver() {
        this.setProtocol("imap");
    }

    public ImapMailReceiver(String url) {
        super(url);
        if (url != null) {
            Assert.isTrue((boolean)url.toLowerCase().startsWith("imap"), (String)"URL must start with 'imap' for the IMAP Mail receiver.");
        } else {
            this.setProtocol("imap");
        }
    }

    public Boolean isShouldMarkMessagesAsRead() {
        return this.shouldMarkMessagesAsRead;
    }

    public void setSearchTermStrategy(SearchTermStrategy searchTermStrategy) {
        Assert.notNull((Object)searchTermStrategy, (String)"'searchTermStrategy' must not be null");
        this.searchTermStrategy = searchTermStrategy;
    }

    public void setShouldMarkMessagesAsRead(Boolean shouldMarkMessagesAsRead) {
        this.shouldMarkMessagesAsRead = shouldMarkMessagesAsRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForNewMessages() throws MessagingException {
        this.openFolder();
        Folder folder = this.getFolder();
        Assert.state((boolean)(folder instanceof IMAPFolder), (String)("folder is not an instance of [" + IMAPFolder.class.getName() + "]"));
        IMAPFolder imapFolder = (IMAPFolder)folder;
        if (imapFolder.hasNewMessages()) {
            return;
        }
        if (!folder.getPermanentFlags().contains(Flags.Flag.RECENT) && this.searchForNewMessages().length > 0) {
            return;
        }
        imapFolder.addMessageCountListener(this.messageCountListener);
        try {
            imapFolder.idle();
        }
        finally {
            imapFolder.removeMessageCountListener(this.messageCountListener);
        }
    }

    protected Message[] searchForNewMessages() throws MessagingException {
        Flags supportedFlags = this.getFolder().getPermanentFlags();
        SearchTerm searchTerm = this.compileSearchTerms(supportedFlags);
        Folder folder = this.getFolder();
        if (folder.isOpen()) {
            Message[] messages;
            for (Message message : messages = searchTerm != null ? folder.search(searchTerm) : folder.getMessages()) {
                ((IMAPMessage)message).setPeek(true);
            }
            return messages;
        }
        throw new MessagingException("Folder is closed");
    }

    private SearchTerm compileSearchTerms(Flags supportedFlags) {
        return this.searchTermStrategy.generateSearchTerm(supportedFlags, this.getFolder());
    }

    protected void setAdditionalFlags(Message message) throws MessagingException {
        super.setAdditionalFlags(message);
        if (this.shouldMarkMessagesAsRead) {
            message.setFlag(Flags.Flag.SEEN, true);
        }
    }

    private class DefaultSearchTermStrategy
    implements SearchTermStrategy {
        private DefaultSearchTermStrategy() {
        }

        public SearchTerm generateSearchTerm(Flags supportedFlags, Folder folder) {
            Object searchTerm = null;
            boolean recentFlagSupported = false;
            if (supportedFlags != null) {
                recentFlagSupported = supportedFlags.contains(Flags.Flag.RECENT);
                if (recentFlagSupported) {
                    searchTerm = new FlagTerm(new Flags(Flags.Flag.RECENT), true);
                }
                if (supportedFlags.contains(Flags.Flag.ANSWERED)) {
                    NotTerm notAnswered = new NotTerm((SearchTerm)new FlagTerm(new Flags(Flags.Flag.ANSWERED), true));
                    searchTerm = searchTerm == null ? notAnswered : new AndTerm((SearchTerm)searchTerm, (SearchTerm)notAnswered);
                }
                if (supportedFlags.contains(Flags.Flag.DELETED)) {
                    NotTerm notDeleted = new NotTerm((SearchTerm)new FlagTerm(new Flags(Flags.Flag.DELETED), true));
                    searchTerm = searchTerm == null ? notDeleted : new AndTerm((SearchTerm)searchTerm, (SearchTerm)notDeleted);
                }
                if (supportedFlags.contains(Flags.Flag.SEEN)) {
                    NotTerm notSeen = new NotTerm((SearchTerm)new FlagTerm(new Flags(Flags.Flag.SEEN), true));
                    searchTerm = searchTerm == null ? notSeen : new AndTerm((SearchTerm)searchTerm, (SearchTerm)notSeen);
                }
            }
            if (!recentFlagSupported) {
                NotTerm notFlagged = null;
                if (folder.getPermanentFlags().contains(Flags.Flag.USER)) {
                    ImapMailReceiver.this.logger.debug((Object)"This email server does not support RECENT flag, but it does support USER flags which will be used to prevent duplicates during email fetch.");
                    Flags siFlags = new Flags();
                    siFlags.add("spring-integration-mail-adapter");
                    notFlagged = new NotTerm((SearchTerm)new FlagTerm(siFlags, true));
                } else {
                    ImapMailReceiver.this.logger.debug((Object)"This email server does not support RECENT or USER flags. System flag 'Flag.FLAGGED' will be used to prevent duplicates during email fetch.");
                    notFlagged = new NotTerm((SearchTerm)new FlagTerm(new Flags(Flags.Flag.FLAGGED), true));
                }
                searchTerm = searchTerm == null ? notFlagged : new AndTerm((SearchTerm)searchTerm, (SearchTerm)notFlagged);
            }
            return searchTerm;
        }
    }

    private static class SimpleMessageCountListener
    extends MessageCountAdapter {
        private SimpleMessageCountListener() {
        }

        public void messagesAdded(MessageCountEvent event) {
            Message[] messages;
            for (Message message : messages = event.getMessages()) {
                try {
                    message.getLineCount();
                }
                catch (MessagingException e) {
                    // empty catch block
                }
            }
        }
    }
}

