/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail;

import jakarta.mail.Folder;
import jakarta.mail.Message;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.mail.ImapMailReceiver;
import org.springframework.integration.mail.event.MailIntegrationEvent;
import org.springframework.integration.transaction.IntegrationResourceHolder;
import org.springframework.integration.transaction.IntegrationResourceHolderSynchronization;
import org.springframework.integration.transaction.TransactionSynchronizationFactory;
import org.springframework.messaging.MessagingException;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.TriggerContext;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class ImapIdleChannelAdapter
extends MessageProducerSupport
implements BeanClassLoaderAware,
ApplicationEventPublisherAware {
    private static final int DEFAULT_RECONNECT_DELAY = 10000;
    private final ExceptionAwarePeriodicTrigger receivingTaskTrigger = new ExceptionAwarePeriodicTrigger();
    private final IdleTask idleTask = new IdleTask();
    private final ImapMailReceiver mailReceiver;
    private TransactionSynchronizationFactory transactionSynchronizationFactory;
    private ClassLoader classLoader;
    private ApplicationEventPublisher applicationEventPublisher;
    private boolean shouldReconnectAutomatically = true;
    private List<Advice> adviceChain;
    private Consumer<Object> messageSender;
    private long reconnectDelay = 10000L;
    private volatile ScheduledFuture<?> receivingTask;

    public ImapIdleChannelAdapter(ImapMailReceiver mailReceiver) {
        Assert.notNull((Object)mailReceiver, (String)"'mailReceiver' must not be null");
        this.mailReceiver = mailReceiver;
    }

    public void setTransactionSynchronizationFactory(TransactionSynchronizationFactory transactionSynchronizationFactory) {
        this.transactionSynchronizationFactory = transactionSynchronizationFactory;
    }

    public void setAdviceChain(List<Advice> adviceChain) {
        this.adviceChain = adviceChain;
    }

    public void setShouldReconnectAutomatically(boolean shouldReconnectAutomatically) {
        this.shouldReconnectAutomatically = shouldReconnectAutomatically;
    }

    public void setReconnectDelay(long reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
    }

    public String getComponentType() {
        return "mail:imap-idle-channel-adapter";
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    protected void onInit() {
        super.onInit();
        Consumer<Object> messageSenderToUse = new MessageSender();
        if (!CollectionUtils.isEmpty(this.adviceChain)) {
            ProxyFactory proxyFactory = new ProxyFactory((Object)messageSenderToUse);
            this.adviceChain.forEach(arg_0 -> ((ProxyFactory)proxyFactory).addAdvice(arg_0));
            for (Advice advice : this.adviceChain) {
                proxyFactory.addAdvice(advice);
            }
            messageSenderToUse = (Consumer)proxyFactory.getProxy(this.classLoader);
        }
        this.messageSender = messageSenderToUse;
    }

    protected void doStart() {
        TaskScheduler scheduler = this.getTaskScheduler();
        Assert.notNull((Object)scheduler, (String)"'taskScheduler' must not be null");
        this.receivingTask = scheduler.schedule((Runnable)new ReceivingTask(), (Trigger)this.receivingTaskTrigger);
    }

    protected void doStop() {
        if (this.receivingTask != null) {
            this.receivingTask.cancel(true);
            this.receivingTask = null;
        }
        this.mailReceiver.cancelPing();
    }

    public void destroy() {
        super.destroy();
        this.mailReceiver.destroy();
    }

    private void publishException(Exception ex) {
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new ImapIdleExceptionEvent(ex));
        } else {
            this.logger.debug(() -> "No application event publisher for exception: " + ex.getMessage());
        }
    }

    private class ExceptionAwarePeriodicTrigger
    implements Trigger {
        private final AtomicBoolean delayNextExecution = new AtomicBoolean();
        private final AtomicBoolean stop = new AtomicBoolean();

        ExceptionAwarePeriodicTrigger() {
        }

        public Instant nextExecution(TriggerContext triggerContext) {
            if (this.stop.getAndSet(false)) {
                return null;
            }
            if (this.delayNextExecution.getAndSet(false)) {
                return Instant.now().plusMillis(ImapIdleChannelAdapter.this.reconnectDelay);
            }
            return Instant.now();
        }

        void delayNextExecution() {
            this.delayNextExecution.set(true);
        }

        void stop() {
            this.stop.set(true);
        }
    }

    private class IdleTask
    implements Runnable {
        IdleTask() {
        }

        @Override
        public void run() {
            if (ImapIdleChannelAdapter.this.isRunning()) {
                try {
                    ImapIdleChannelAdapter.this.logger.debug((CharSequence)"waiting for mail");
                    ImapIdleChannelAdapter.this.mailReceiver.waitForNewMessages();
                    Folder folder = ImapIdleChannelAdapter.this.mailReceiver.getFolder();
                    if (folder != null && folder.isOpen() && ImapIdleChannelAdapter.this.isRunning()) {
                        Object[] mailMessages = ImapIdleChannelAdapter.this.mailReceiver.receive();
                        ImapIdleChannelAdapter.this.logger.debug(() -> "received " + mailMessages.length + " mail messages");
                        for (Object mailMessage : mailMessages) {
                            if (!ImapIdleChannelAdapter.this.isRunning()) continue;
                            ImapIdleChannelAdapter.this.messageSender.accept(mailMessage);
                        }
                    }
                }
                catch (jakarta.mail.MessagingException ex) {
                    ImapIdleChannelAdapter.this.logger.warn((Throwable)ex, (CharSequence)"error occurred in idle task");
                    if (ImapIdleChannelAdapter.this.shouldReconnectAutomatically) {
                        throw new IllegalStateException("Failure in 'idle' task. Will resubmit.", ex);
                    }
                    throw new MessagingException("Failure in 'idle' task. Will NOT resubmit.", (Throwable)ex);
                }
            }
        }
    }

    private class MessageSender
    implements Consumer<Object> {
        MessageSender() {
        }

        @Override
        public void accept(Object mailMessage) {
            TransactionSynchronization synchronization;
            org.springframework.messaging.Message messageToSend;
            org.springframework.messaging.Message message = messageToSend = mailMessage instanceof Message ? ImapIdleChannelAdapter.this.getMessageBuilderFactory().withPayload(mailMessage).build() : (org.springframework.messaging.Message)mailMessage;
            if (TransactionSynchronizationManager.isActualTransactionActive() && ImapIdleChannelAdapter.this.transactionSynchronizationFactory != null && (synchronization = ImapIdleChannelAdapter.this.transactionSynchronizationFactory.create((Object)this)) != null) {
                Object resourceHolder;
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)synchronization);
                if (synchronization instanceof IntegrationResourceHolderSynchronization) {
                    IntegrationResourceHolderSynchronization integrationSync = (IntegrationResourceHolderSynchronization)synchronization;
                    if (!TransactionSynchronizationManager.hasResource((Object)this)) {
                        TransactionSynchronizationManager.bindResource((Object)this, (Object)integrationSync.getResourceHolder());
                    }
                }
                if ((resourceHolder = TransactionSynchronizationManager.getResource((Object)this)) instanceof IntegrationResourceHolder) {
                    IntegrationResourceHolder integrationResourceHolder = (IntegrationResourceHolder)resourceHolder;
                    integrationResourceHolder.setMessage(messageToSend);
                }
            }
            ImapIdleChannelAdapter.this.sendMessage(messageToSend);
        }
    }

    private class ReceivingTask
    implements Runnable {
        ReceivingTask() {
        }

        @Override
        public void run() {
            if (ImapIdleChannelAdapter.this.isRunning()) {
                try {
                    ImapIdleChannelAdapter.this.idleTask.run();
                    ImapIdleChannelAdapter.this.logger.debug((CharSequence)"Task completed successfully. Re-scheduling it again right away.");
                }
                catch (Exception ex) {
                    Throwable throwable;
                    if (ImapIdleChannelAdapter.this.shouldReconnectAutomatically && (throwable = ex.getCause()) instanceof jakarta.mail.MessagingException) {
                        jakarta.mail.MessagingException messagingException = (jakarta.mail.MessagingException)throwable;
                        ImapIdleChannelAdapter.this.logger.info((Throwable)messagingException, () -> "Failed to execute IDLE task. Will attempt to resubmit in " + ImapIdleChannelAdapter.this.reconnectDelay + " milliseconds.");
                        ImapIdleChannelAdapter.this.receivingTaskTrigger.delayNextExecution();
                    } else {
                        ImapIdleChannelAdapter.this.logger.warn((Throwable)ex, (CharSequence)"Failed to execute IDLE task. Won't resubmit since not a 'shouldReconnectAutomatically' or not a 'jakarta.mail.MessagingException'");
                        ImapIdleChannelAdapter.this.receivingTaskTrigger.stop();
                    }
                    ImapIdleChannelAdapter.this.publishException(ex);
                }
            }
        }
    }

    public class ImapIdleExceptionEvent
    extends MailIntegrationEvent {
        private static final long serialVersionUID = -5875388810251967741L;

        ImapIdleExceptionEvent(Exception ex) {
            super((Object)ImapIdleChannelAdapter.this, ex);
        }
    }
}

