/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mongodb.store;

import com.mongodb.DB;
import com.mongodb.MongoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import org.springframework.dao.DataAccessException;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.DbCallback;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.integration.mongodb.store.AbstractConfigurableMongoDbMessageStore;
import org.springframework.integration.mongodb.store.MessageDocument;
import org.springframework.integration.store.MessageGroup;
import org.springframework.integration.store.MessageGroupMetadata;
import org.springframework.integration.store.MessageGroupStore;
import org.springframework.integration.store.MessageStore;
import org.springframework.integration.store.SimpleMessageGroup;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class ConfigurableMongoDbMessageStore
extends AbstractConfigurableMongoDbMessageStore
implements MessageStore,
MessageGroupStore,
Iterable<MessageGroup> {
    public static final String DEFAULT_COLLECTION_NAME = "configurableStoreMessages";
    private final Collection<MessageGroupStore.MessageGroupCallback> expiryCallbacks = new LinkedHashSet<MessageGroupStore.MessageGroupCallback>();
    private volatile boolean timeoutOnIdle;

    public ConfigurableMongoDbMessageStore(MongoTemplate mongoTemplate) {
        this(mongoTemplate, DEFAULT_COLLECTION_NAME);
    }

    public ConfigurableMongoDbMessageStore(MongoTemplate mongoTemplate, String collectionName) {
        super(mongoTemplate, collectionName);
    }

    public ConfigurableMongoDbMessageStore(MongoDbFactory mongoDbFactory) {
        this(mongoDbFactory, null, DEFAULT_COLLECTION_NAME);
    }

    public ConfigurableMongoDbMessageStore(MongoDbFactory mongoDbFactory, MappingMongoConverter mappingMongoConverter) {
        this(mongoDbFactory, mappingMongoConverter, DEFAULT_COLLECTION_NAME);
    }

    public ConfigurableMongoDbMessageStore(MongoDbFactory mongoDbFactory, String collectionName) {
        this(mongoDbFactory, null, collectionName);
    }

    public ConfigurableMongoDbMessageStore(MongoDbFactory mongoDbFactory, MappingMongoConverter mappingMongoConverter, String collectionName) {
        super(mongoDbFactory, mappingMongoConverter, collectionName);
    }

    public void setExpiryCallbacks(Collection<MessageGroupStore.MessageGroupCallback> expiryCallbacks) {
        for (MessageGroupStore.MessageGroupCallback callback : expiryCallbacks) {
            this.registerMessageGroupExpiryCallback(callback);
        }
    }

    public boolean isTimeoutOnIdle() {
        return this.timeoutOnIdle;
    }

    public void setTimeoutOnIdle(boolean timeoutOnIdle) {
        this.timeoutOnIdle = timeoutOnIdle;
    }

    public <T> Message<T> addMessage(Message<T> message) {
        Assert.notNull(message, (String)"'message' must not be null");
        this.addMessageDocument(new MessageDocument(message));
        return message;
    }

    public Message<?> removeMessage(UUID id) {
        Assert.notNull((Object)id, (String)"'id' must not be null");
        Query query = Query.query((Criteria)Criteria.where((String)"messageId").is((Object)id));
        MessageDocument document = (MessageDocument)this.mongoTemplate.findAndRemove(query, MessageDocument.class, this.collectionName);
        return document != null ? document.getMessage() : null;
    }

    public long getMessageCount() {
        Query query = Query.query((Criteria)Criteria.where((String)"messageId").exists(true).and("groupId").exists(false));
        return this.mongoTemplate.getCollection(this.collectionName).count(query.getQueryObject());
    }

    public MessageGroup getMessageGroup(Object groupId) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        Query query = ConfigurableMongoDbMessageStore.groupOrderQuery(groupId);
        List messageDocuments = this.mongoTemplate.find(query, MessageDocument.class, this.collectionName);
        long createdTime = 0L;
        long lastModifiedTime = 0L;
        int lastReleasedSequence = 0;
        boolean complete = false;
        if (messageDocuments.size() > 0) {
            MessageDocument document = (MessageDocument)messageDocuments.get(0);
            createdTime = document.getCreatedTime();
            lastModifiedTime = document.getLastModifiedTime();
            complete = document.isComplete();
            lastReleasedSequence = document.getLastReleasedSequence();
        }
        ArrayList messages = new ArrayList();
        for (MessageDocument document : messageDocuments) {
            messages.add(document.getMessage());
        }
        SimpleMessageGroup group = new SimpleMessageGroup(messages, groupId, createdTime, complete);
        group.setLastReleasedMessageSequenceNumber(lastReleasedSequence);
        group.setLastModified(lastModifiedTime);
        return group;
    }

    public MessageGroup addMessageToGroup(final Object groupId, final Message<?> message) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        Assert.notNull(message, (String)"'message' must not be null");
        return (MessageGroup)this.mongoTemplate.executeInSession((DbCallback)new DbCallback<MessageGroup>(){

            public MessageGroup doInDB(DB db) throws MongoException, DataAccessException {
                Query query = ConfigurableMongoDbMessageStore.groupOrderQuery(groupId);
                MessageDocument messageDocument = (MessageDocument)ConfigurableMongoDbMessageStore.this.mongoTemplate.findOne(query, MessageDocument.class, ConfigurableMongoDbMessageStore.this.collectionName);
                long createdTime = 0L;
                int lastReleasedSequence = 0;
                boolean complete = false;
                if (messageDocument != null) {
                    createdTime = messageDocument.getCreatedTime();
                    lastReleasedSequence = messageDocument.getLastReleasedSequence();
                    complete = messageDocument.isComplete();
                }
                MessageDocument document = new MessageDocument(message);
                document.setGroupId(groupId);
                document.setComplete(complete);
                document.setLastReleasedSequence(lastReleasedSequence);
                document.setCreatedTime(createdTime == 0L ? System.currentTimeMillis() : createdTime);
                document.setLastModifiedTime(System.currentTimeMillis());
                document.setSequence(ConfigurableMongoDbMessageStore.this.getNextId());
                ConfigurableMongoDbMessageStore.this.addMessageDocument(document);
                return ConfigurableMongoDbMessageStore.this.getMessageGroup(groupId);
            }
        });
    }

    public MessageGroup removeMessageFromGroup(final Object groupId, final Message<?> messageToRemove) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        Assert.notNull(messageToRemove, (String)"'messageToRemove' must not be null");
        return (MessageGroup)this.mongoTemplate.executeInSession((DbCallback)new DbCallback<MessageGroup>(){

            public MessageGroup doInDB(DB db) throws MongoException, DataAccessException {
                Query query = AbstractConfigurableMongoDbMessageStore.groupIdQuery(groupId).addCriteria(Criteria.where((String)"messageId").is((Object)messageToRemove.getHeaders().getId()));
                ConfigurableMongoDbMessageStore.this.mongoTemplate.remove(query, ConfigurableMongoDbMessageStore.this.collectionName);
                ConfigurableMongoDbMessageStore.this.updateGroup(groupId, ConfigurableMongoDbMessageStore.lastModifiedUpdate());
                return ConfigurableMongoDbMessageStore.this.getMessageGroup(groupId);
            }
        });
    }

    public Message<?> pollMessageFromGroup(final Object groupId) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        return (Message)this.mongoTemplate.executeInSession(new DbCallback<Message<?>>(){

            public Message<?> doInDB(DB db) throws MongoException, DataAccessException {
                Sort sort = new Sort(new String[]{"lastModifiedTime", "sequence"});
                Query query = AbstractConfigurableMongoDbMessageStore.groupIdQuery(groupId).with(sort);
                MessageDocument document = (MessageDocument)ConfigurableMongoDbMessageStore.this.mongoTemplate.findAndRemove(query, MessageDocument.class, ConfigurableMongoDbMessageStore.this.collectionName);
                Message<?> message = null;
                if (document != null) {
                    message = document.getMessage();
                    ConfigurableMongoDbMessageStore.this.updateGroup(groupId, ConfigurableMongoDbMessageStore.lastModifiedUpdate());
                }
                return message;
            }
        });
    }

    public void setLastReleasedSequenceNumberForGroup(Object groupId, int sequenceNumber) {
        this.updateGroup(groupId, ConfigurableMongoDbMessageStore.lastModifiedUpdate().set("lastReleasedSequence", (Object)sequenceNumber));
    }

    public void completeGroup(Object groupId) {
        this.updateGroup(groupId, ConfigurableMongoDbMessageStore.lastModifiedUpdate().set("complete", (Object)true));
    }

    @Override
    public Iterator<MessageGroup> iterator() {
        return (Iterator)this.mongoTemplate.executeInSession((DbCallback)new DbCallback<Iterator<MessageGroup>>(){

            public Iterator<MessageGroup> doInDB(DB db) throws MongoException, DataAccessException {
                ArrayList<MessageGroup> messageGroups = new ArrayList<MessageGroup>();
                Query query = Query.query((Criteria)Criteria.where((String)"groupId").exists(true));
                List groupIds = ConfigurableMongoDbMessageStore.this.mongoTemplate.getCollection(ConfigurableMongoDbMessageStore.this.collectionName).distinct("groupId", query.getQueryObject());
                for (Object groupId : groupIds) {
                    messageGroups.add(ConfigurableMongoDbMessageStore.this.getMessageGroup(groupId));
                }
                return messageGroups.iterator();
            }
        });
    }

    public void registerMessageGroupExpiryCallback(MessageGroupStore.MessageGroupCallback callback) {
        this.expiryCallbacks.add(callback);
    }

    public int expireMessageGroups(long timeout) {
        int count = 0;
        long threshold = System.currentTimeMillis() - timeout;
        for (MessageGroup group : this) {
            long timestamp = group.getTimestamp();
            if (this.isTimeoutOnIdle() && group.getLastModified() > 0L) {
                timestamp = group.getLastModified();
            }
            if (timestamp > threshold) continue;
            ++count;
            this.expire(group);
        }
        return count;
    }

    @ManagedAttribute
    public int getMessageCountForAllMessageGroups() {
        Query query = Query.query((Criteria)Criteria.where((String)"messageId").exists(true).and("groupId").exists(true));
        long count = this.mongoTemplate.count(query, this.collectionName);
        Assert.isTrue((count <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Message count is out of Integer's range");
        return (int)count;
    }

    @ManagedAttribute
    public int getMessageGroupCount() {
        Query query = Query.query((Criteria)Criteria.where((String)"groupId").exists(true));
        return this.mongoTemplate.getCollection(this.collectionName).distinct("groupId", query.getQueryObject()).size();
    }

    public MessageGroupMetadata getGroupMetadata(Object groupId) {
        throw new UnsupportedOperationException("Not yet implemented for this store");
    }

    public Message<?> getOneMessageFromGroup(Object groupId) {
        throw new UnsupportedOperationException("Not yet implemented for this store");
    }

    private void expire(MessageGroup group) {
        RuntimeException exception = null;
        for (MessageGroupStore.MessageGroupCallback callback : this.expiryCallbacks) {
            try {
                callback.execute((MessageGroupStore)this, group);
            }
            catch (RuntimeException e) {
                if (exception == null) {
                    exception = e;
                }
                this.logger.error((Object)"Exception in expiry callback", (Throwable)e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private void updateGroup(Object groupId, Update update) {
        this.mongoTemplate.updateFirst(ConfigurableMongoDbMessageStore.groupOrderQuery(groupId), update, this.collectionName);
    }

    private static Update lastModifiedUpdate() {
        return Update.update((String)"lastModifiedTime", (Object)System.currentTimeMillis());
    }

    private static Query groupOrderQuery(Object groupId) {
        Sort sort = new Sort(Sort.Direction.DESC, new String[]{"lastModifiedTime", "sequence"});
        return ConfigurableMongoDbMessageStore.groupIdQuery(groupId).with(sort);
    }
}

