/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mongodb.metadata;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.dao.DataAccessException;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.CollectionCallback;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.ScriptOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.script.NamedMongoScript;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.util.Assert;

public class MongoDbMetadataStore
implements ConcurrentMetadataStore {
    private static final String DEFAULT_COLLECTION_NAME = "metadataStore";
    private static final String ID_FIELD = "_id";
    private static final String VALUE = "value";
    private static final String PUT_IF_ABSENT_FUNCTION = "function putIfAbsent(collection, key, value){   var alreadyPresent = db[collection].findOne({\"_id\": key}, {\"_id\": 0});   if(alreadyPresent == null){      db[collection].insert({\"_id\": key, \"value\": value});       return null;    }   return alreadyPresent;}";
    private static final String PUT_IF_ABSENT_SCRIPT_NAME = "metadataStorePutIfAbsent";
    private final MongoTemplate template;
    private final String collectionName;
    private final ScriptOperations scriptOperations;
    private volatile boolean scriptInitialized;

    public MongoDbMetadataStore(MongoDbFactory factory) {
        this(factory, DEFAULT_COLLECTION_NAME);
    }

    public MongoDbMetadataStore(MongoDbFactory factory, String collectionName) {
        this(new MongoTemplate(factory), collectionName);
    }

    public MongoDbMetadataStore(MongoTemplate template) {
        this(template, DEFAULT_COLLECTION_NAME);
    }

    public MongoDbMetadataStore(MongoTemplate template, String collectionName) {
        Assert.notNull((Object)template, (String)"'template' must not be null.");
        Assert.hasText((String)collectionName, (String)"'collectionName' must not be empty.");
        this.template = template;
        this.collectionName = collectionName;
        this.scriptOperations = template.scriptOps();
    }

    public void put(String key, String value) {
        Assert.hasText((String)key, (String)"'key' must not be empty.");
        Assert.hasText((String)value, (String)"'value' must not be empty.");
        final HashMap<String, String> entry = new HashMap<String, String>();
        entry.put(ID_FIELD, key);
        entry.put(VALUE, value);
        this.template.execute(this.collectionName, (CollectionCallback)new CollectionCallback<Object>(){

            public Object doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                return collection.save((DBObject)new BasicDBObject(entry));
            }
        });
    }

    public String get(String key) {
        Assert.hasText((String)key, (String)"'key' must not be empty.");
        Query query = new Query((CriteriaDefinition)Criteria.where((String)ID_FIELD).is((Object)key));
        query.fields().exclude(ID_FIELD);
        Map result = (Map)this.template.findOne(query, Map.class, this.collectionName);
        return result == null ? null : (String)result.get(VALUE);
    }

    public String remove(String key) {
        Assert.hasText((String)key, (String)"'key' must not be empty.");
        Query query = new Query((CriteriaDefinition)Criteria.where((String)ID_FIELD).is((Object)key));
        query.fields().exclude(ID_FIELD);
        Map result = (Map)this.template.findAndRemove(query, Map.class, this.collectionName);
        return result == null ? null : (String)result.get(VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String putIfAbsent(String key, String value) {
        BasicDBObject result;
        Assert.hasText((String)key, (String)"'key' must not be empty.");
        Assert.hasText((String)value, (String)"'value' must not be empty.");
        if (!this.scriptInitialized) {
            MongoDbMetadataStore mongoDbMetadataStore = this;
            synchronized (mongoDbMetadataStore) {
                if (!this.scriptInitialized) {
                    this.scriptOperations.register(new NamedMongoScript(PUT_IF_ABSENT_SCRIPT_NAME, PUT_IF_ABSENT_FUNCTION));
                    this.scriptInitialized = true;
                }
            }
        }
        return (result = (BasicDBObject)this.scriptOperations.call(PUT_IF_ABSENT_SCRIPT_NAME, new Object[]{this.collectionName, key, value})) == null ? null : (String)result.get(VALUE);
    }

    public boolean replace(String key, String oldValue, String newValue) {
        Assert.hasText((String)key, (String)"'key' must not be empty.");
        Assert.hasText((String)oldValue, (String)"'oldValue' must not be empty.");
        Assert.hasText((String)newValue, (String)"'newValue' must not be empty.");
        Query query = new Query((CriteriaDefinition)Criteria.where((String)ID_FIELD).is((Object)key).and(VALUE).is((Object)oldValue));
        return this.template.updateFirst(query, Update.update((String)VALUE, (Object)newValue), this.collectionName).isUpdateOfExisting();
    }
}

