/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mongodb.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.serializer.support.DeserializingConverter;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.IndexOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.CustomConversions;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.integration.mongodb.store.MessageDocument;
import org.springframework.integration.store.AbstractMessageGroupStore;
import org.springframework.integration.store.BasicMessageGroupStore;
import org.springframework.integration.store.MessageGroup;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public abstract class AbstractConfigurableMongoDbMessageStore
extends AbstractMessageGroupStore
implements BasicMessageGroupStore,
InitializingBean,
ApplicationContextAware {
    public static final String SEQUENCE_NAME = "messagesSequence";
    public static final String SAVED_KEY = "MongoDbMessageStore.SAVED";
    public static final String CREATED_DATE_KEY = "MongoDbMessageStore.CREATED_DATE";
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected final String collectionName;
    protected final MongoDbFactory mongoDbFactory;
    protected MongoTemplate mongoTemplate;
    protected MappingMongoConverter mappingMongoConverter;
    protected ApplicationContext applicationContext;
    protected MessageBuilderFactory messageBuilderFactory = new DefaultMessageBuilderFactory();

    public AbstractConfigurableMongoDbMessageStore(MongoTemplate mongoTemplate, String collectionName) {
        Assert.notNull((Object)"'mongoTemplate' must not be null");
        Assert.hasText((String)"'collectionName' must not be empty");
        this.collectionName = collectionName;
        this.mongoTemplate = mongoTemplate;
        this.mongoDbFactory = null;
    }

    public AbstractConfigurableMongoDbMessageStore(MongoDbFactory mongoDbFactory, String collectionName) {
        this(mongoDbFactory, null, collectionName);
    }

    public AbstractConfigurableMongoDbMessageStore(MongoDbFactory mongoDbFactory, MappingMongoConverter mappingMongoConverter, String collectionName) {
        Assert.notNull((Object)"'mongoDbFactory' must not be null");
        Assert.hasText((String)"'collectionName' must not be empty");
        this.collectionName = collectionName;
        this.mongoDbFactory = mongoDbFactory;
        this.mappingMongoConverter = mappingMongoConverter;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.mongoTemplate == null) {
            if (this.mappingMongoConverter == null) {
                this.mappingMongoConverter = new MappingMongoConverter((DbRefResolver)new DefaultDbRefResolver(this.mongoDbFactory), (MappingContext)new MongoMappingContext());
                this.mappingMongoConverter.setApplicationContext(this.applicationContext);
                ArrayList<MongoDbMessageBytesConverter> customConverters = new ArrayList<MongoDbMessageBytesConverter>();
                customConverters.add(new MongoDbMessageBytesConverter());
                this.mappingMongoConverter.setCustomConversions(new CustomConversions(customConverters));
                this.mappingMongoConverter.afterPropertiesSet();
            }
            this.mongoTemplate = new MongoTemplate(this.mongoDbFactory, (MongoConverter)this.mappingMongoConverter);
            if (this.applicationContext != null) {
                this.mongoTemplate.setApplicationContext(this.applicationContext);
            }
        }
        this.messageBuilderFactory = IntegrationUtils.getMessageBuilderFactory((BeanFactory)this.applicationContext);
        IndexOperations indexOperations = this.mongoTemplate.indexOps(this.collectionName);
        indexOperations.ensureIndex((IndexDefinition)new Index("messageId", Sort.Direction.ASC));
        indexOperations.ensureIndex((IndexDefinition)new Index("groupId", Sort.Direction.ASC).on("lastModifiedTime", Sort.Direction.DESC).on("sequence", Sort.Direction.DESC));
    }

    public Message<?> getMessage(UUID id) {
        Assert.notNull((Object)id, (String)"'id' must not be null");
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"messageId").is((Object)id));
        MessageDocument document = (MessageDocument)this.mongoTemplate.findOne(query, MessageDocument.class, this.collectionName);
        return document != null ? document.getMessage() : null;
    }

    public void removeMessageGroup(Object groupId) {
        this.mongoTemplate.remove(AbstractConfigurableMongoDbMessageStore.groupIdQuery(groupId), this.collectionName);
    }

    public int messageGroupSize(Object groupId) {
        long lCount = this.mongoTemplate.count(AbstractConfigurableMongoDbMessageStore.groupIdQuery(groupId), this.collectionName);
        Assert.isTrue((lCount <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Message count is out of Integer's range");
        return (int)lCount;
    }

    protected int getNextId() {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)SEQUENCE_NAME));
        query.fields().include("sequence");
        return (Integer)((Map)this.mongoTemplate.findAndModify(query, new Update().inc("sequence", (Number)1), FindAndModifyOptions.options().returnNew(true).upsert(true), Map.class, this.collectionName)).get("sequence");
    }

    protected void addMessageDocument(MessageDocument document) {
        Message<?> saved;
        Message<?> message = document.getMessage();
        if (message.getHeaders().containsKey((Object)SAVED_KEY) && (saved = this.getMessage(message.getHeaders().getId())) != null && saved.equals(message)) {
            return;
        }
        long createdDate = document.getCreatedTime() == 0L ? System.currentTimeMillis() : document.getCreatedTime();
        Message result = this.messageBuilderFactory.fromMessage(message).setHeader(SAVED_KEY, (Object)Boolean.TRUE).setHeader(CREATED_DATE_KEY, (Object)createdDate).build();
        Map innerMap = (Map)new DirectFieldAccessor((Object)result.getHeaders()).getPropertyValue("headers");
        innerMap.put("id", message.getHeaders().get((Object)"id"));
        innerMap.put("timestamp", message.getHeaders().get((Object)"timestamp"));
        document.setCreatedTime(createdDate);
        this.mongoTemplate.insert((Object)document, this.collectionName);
    }

    protected static Query groupIdQuery(Object groupId) {
        return Query.query((CriteriaDefinition)Criteria.where((String)"groupId").is(groupId));
    }

    @Deprecated
    public MessageGroup removeMessageFromGroup(Object key, Message<?> messageToRemove) {
        throw new UnsupportedOperationException("The operation isn't implemented for this class.");
    }

    public void removeMessagesFromGroup(Object key, Collection<Message<?>> messages) {
        throw new UnsupportedOperationException("The operation isn't implemented for this class.");
    }

    public void setLastReleasedSequenceNumberForGroup(Object groupId, int sequenceNumber) {
        throw new UnsupportedOperationException("The operation isn't implemented for this class.");
    }

    public Iterator<MessageGroup> iterator() {
        throw new UnsupportedOperationException("The operation isn't implemented for this class.");
    }

    public void completeGroup(Object groupId) {
        throw new UnsupportedOperationException("The operation isn't implemented for this class.");
    }

    public Message<?> getOneMessageFromGroup(Object groupId) {
        throw new UnsupportedOperationException("The operation isn't implemented for this class.");
    }

    public void addMessagesToGroup(Object groupId, Message<?> ... messages) {
        throw new UnsupportedOperationException("The operation isn't implemented for this class.");
    }

    public Collection<Message<?>> getMessagesForGroup(Object groupId) {
        throw new UnsupportedOperationException("The operation isn't implemented for this class.");
    }

    private static class MongoDbMessageBytesConverter
    implements GenericConverter {
        private final Converter<Object, byte[]> serializingConverter = new SerializingConverter();
        private final Converter<byte[], Object> deserializingConverter = new DeserializingConverter();

        private MongoDbMessageBytesConverter() {
        }

        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            HashSet<GenericConverter.ConvertiblePair> convertiblePairs = new HashSet<GenericConverter.ConvertiblePair>();
            convertiblePairs.add(new GenericConverter.ConvertiblePair(Message.class, byte[].class));
            convertiblePairs.add(new GenericConverter.ConvertiblePair(byte[].class, Message.class));
            return convertiblePairs;
        }

        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (Message.class.isAssignableFrom(sourceType.getObjectType())) {
                return this.serializingConverter.convert(source);
            }
            return this.deserializingConverter.convert((Object)((byte[])source));
        }
    }
}

