/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mongodb.support;

import java.util.HashSet;
import java.util.Set;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.serializer.support.DeserializingConverter;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.messaging.Message;

public class MongoDbMessageBytesConverter
implements GenericConverter {
    private final Converter<Object, byte[]> serializingConverter = new SerializingConverter();
    private final Converter<byte[], Object> deserializingConverter = new DeserializingConverter();

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        HashSet<GenericConverter.ConvertiblePair> convertiblePairs = new HashSet<GenericConverter.ConvertiblePair>();
        convertiblePairs.add(new GenericConverter.ConvertiblePair(Message.class, byte[].class));
        convertiblePairs.add(new GenericConverter.ConvertiblePair(byte[].class, Message.class));
        return convertiblePairs;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (Message.class.isAssignableFrom(sourceType.getObjectType())) {
            return this.serializingConverter.convert(source);
        }
        return this.deserializingConverter.convert((Object)((byte[])source));
    }
}

