/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mongodb.dsl;

import java.util.function.Function;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.CollectionCallback;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.dsl.MessageHandlerSpec;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.mongodb.outbound.MongoDbOutboundGateway;
import org.springframework.messaging.Message;

public class MongoDbOutboundGatewaySpec
extends MessageHandlerSpec<MongoDbOutboundGatewaySpec, MongoDbOutboundGateway> {
    MongoDbOutboundGatewaySpec(MongoDbFactory mongoDbFactory, MongoConverter mongoConverter) {
        this.target = new MongoDbOutboundGateway(mongoDbFactory, mongoConverter);
        ((MongoDbOutboundGateway)((Object)this.target)).setRequiresReply(true);
    }

    MongoDbOutboundGatewaySpec(MongoOperations mongoTemplate) {
        this.target = new MongoDbOutboundGateway(mongoTemplate);
        ((MongoDbOutboundGateway)((Object)this.target)).setRequiresReply(true);
    }

    public MongoDbOutboundGatewaySpec expectSingleResult(boolean expectSingleResult) {
        ((MongoDbOutboundGateway)((Object)this.target)).setExpectSingleResult(expectSingleResult);
        return this;
    }

    public MongoDbOutboundGatewaySpec query(String query) {
        ((MongoDbOutboundGateway)((Object)this.target)).setQueryExpression((Expression)new LiteralExpression(query));
        return this;
    }

    public MongoDbOutboundGatewaySpec queryExpression(String queryExpression) {
        ((MongoDbOutboundGateway)((Object)this.target)).setQueryExpressionString(queryExpression);
        return this;
    }

    public <P> MongoDbOutboundGatewaySpec queryFunction(Function<Message<P>, Query> queryFunction) {
        ((MongoDbOutboundGateway)((Object)this.target)).setQueryExpression((Expression)new FunctionExpression(queryFunction));
        return this;
    }

    public MongoDbOutboundGatewaySpec entityClass(Class<?> entityClass) {
        ((MongoDbOutboundGateway)((Object)this.target)).setEntityClass(entityClass);
        return this;
    }

    public MongoDbOutboundGatewaySpec collectionName(String collectionName) {
        ((MongoDbOutboundGateway)((Object)this.target)).setCollectionNameExpression((Expression)new LiteralExpression(collectionName));
        return this;
    }

    public MongoDbOutboundGatewaySpec collectionNameExpression(String collectionNameExpression) {
        ((MongoDbOutboundGateway)((Object)this.target)).setCollectionNameExpressionString(collectionNameExpression);
        return this;
    }

    public <P> MongoDbOutboundGatewaySpec collectionNameFunction(Function<Message<P>, String> collectionNameFunction) {
        ((MongoDbOutboundGateway)((Object)this.target)).setCollectionNameExpression((Expression)new FunctionExpression(collectionNameFunction));
        return this;
    }

    public <P> MongoDbOutboundGatewaySpec collectionCallback(CollectionCallback<P> collectionCallback) {
        ((MongoDbOutboundGateway)((Object)this.target)).setCollectionCallback(collectionCallback);
        return this;
    }
}

