/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mongodb.inbound;

import java.util.Collection;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.util.Pair;
import org.springframework.expression.Expression;
import org.springframework.integration.mongodb.inbound.AbstractMongoDbMessageSource;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.transaction.IntegrationResourceHolder;
import org.springframework.lang.Nullable;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class MongoDbMessageSource
extends AbstractMongoDbMessageSource<Object> {
    @Nullable
    private final MongoDatabaseFactory mongoDbFactory;
    private MongoOperations mongoTemplate;

    public MongoDbMessageSource(MongoDatabaseFactory mongoDbFactory, Expression queryExpression) {
        super(queryExpression);
        Assert.notNull((Object)mongoDbFactory, (String)"'mongoDbFactory' must not be null");
        this.mongoDbFactory = mongoDbFactory;
    }

    public MongoDbMessageSource(MongoOperations mongoTemplate, Expression queryExpression) {
        super(queryExpression);
        Assert.notNull((Object)mongoTemplate, (String)"'mongoTemplate' must not be null");
        this.mongoDbFactory = null;
        this.mongoTemplate = mongoTemplate;
    }

    public String getComponentType() {
        return "mongo:inbound-channel-adapter";
    }

    @Override
    protected void onInit() {
        super.onInit();
        if (this.mongoDbFactory != null) {
            MongoTemplate template = new MongoTemplate(this.mongoDbFactory, this.getMongoConverter());
            ApplicationContext applicationContext = this.getApplicationContext();
            if (applicationContext != null) {
                template.setApplicationContext(applicationContext);
            }
            this.mongoTemplate = template;
        }
        this.setMongoConverter(this.mongoTemplate.getConverter());
        this.setInitialized(true);
    }

    protected Object doReceive() {
        Object holder;
        Assert.isTrue((boolean)this.isInitialized(), (String)"This class is not yet initialized. Invoke its afterPropertiesSet() method");
        AbstractIntegrationMessageBuilder messageBuilder = null;
        Query query = this.evaluateQueryExpression();
        String collectionName = this.evaluateCollectionNameExpression();
        Object result = null;
        if (this.isExpectSingleResult()) {
            result = this.mongoTemplate.findOne(query, this.getEntityClass(), collectionName);
        } else {
            List results = this.mongoTemplate.find(query, this.getEntityClass(), collectionName);
            if (!CollectionUtils.isEmpty((Collection)results)) {
                result = results;
            }
        }
        if (result != null) {
            this.updateIfAny(result, collectionName);
            messageBuilder = this.getMessageBuilderFactory().withPayload(result).setHeader("mongo_collectionName", (Object)collectionName);
        }
        if ((holder = TransactionSynchronizationManager.getResource((Object)((Object)this))) != null) {
            Assert.isInstanceOf(IntegrationResourceHolder.class, (Object)holder);
            ((IntegrationResourceHolder)holder).addAttribute("mongoTemplate", (Object)this.mongoTemplate);
        }
        return messageBuilder;
    }

    private void updateIfAny(Object result, String collectionName) {
        Update update = this.evaluateUpdateExpression();
        if (update != null) {
            if (result instanceof List) {
                this.mongoTemplate.updateMulti(this.getByIdInQuery((Collection)result), (UpdateDefinition)update, collectionName);
            } else {
                Pair<String, Object> idPair = this.idForEntity(result);
                Query query = new Query((CriteriaDefinition)Criteria.where((String)((String)idPair.getFirst())).is(idPair.getSecond()));
                this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, collectionName);
            }
        }
    }
}

