/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mqtt.outbound;

import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.expression.Expression;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.handler.ExpressionEvaluatingMessageProcessor;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.mqtt.core.ClientManager;
import org.springframework.integration.mqtt.support.MqttMessageConverter;
import org.springframework.integration.support.management.ManageableLifecycle;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.Assert;

public abstract class AbstractMqttMessageHandler<T, C>
extends AbstractMessageHandler
implements ManageableLifecycle,
ApplicationEventPublisherAware {
    public static final long DISCONNECT_COMPLETION_TIMEOUT = 5000L;
    public static final long DEFAULT_COMPLETION_TIMEOUT = 30000L;
    private static final MessageProcessor<String> DEFAULT_TOPIC_PROCESSOR = message -> (String)message.getHeaders().get((Object)"mqtt_topic", String.class);
    private final AtomicBoolean running = new AtomicBoolean();
    private final String url;
    private final String clientId;
    private final ClientManager<T, C> clientManager;
    private long completionTimeout = 30000L;
    private long disconnectCompletionTimeout = 5000L;
    private String defaultTopic;
    private MessageProcessor<String> topicProcessor = DEFAULT_TOPIC_PROCESSOR;
    private int defaultQos = 0;
    private MessageProcessor<Integer> qosProcessor = MqttMessageConverter.defaultQosProcessor();
    private boolean defaultRetained;
    private MessageProcessor<Boolean> retainedProcessor = MqttMessageConverter.defaultRetainedProcessor();
    private MessageConverter converter;
    private ApplicationEventPublisher applicationEventPublisher;
    private int clientInstance;

    public AbstractMqttMessageHandler(@Nullable String url, String clientId) {
        Assert.hasText((String)clientId, (String)"'clientId' cannot be null or empty");
        this.url = url;
        this.clientId = clientId;
        this.clientManager = null;
    }

    public AbstractMqttMessageHandler(ClientManager<T, C> clientManager) {
        Assert.notNull(clientManager, (String)"'clientManager' cannot be null or empty");
        this.clientManager = clientManager;
        this.url = null;
        this.clientId = null;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    protected ApplicationEventPublisher getApplicationEventPublisher() {
        return this.applicationEventPublisher;
    }

    public void setDefaultTopic(String defaultTopic) {
        this.defaultTopic = defaultTopic;
    }

    protected String getDefaultTopic() {
        return this.defaultTopic;
    }

    public void setTopicExpression(Expression topicExpression) {
        Assert.notNull((Object)topicExpression, (String)"'topicExpression' cannot be null");
        this.topicProcessor = new ExpressionEvaluatingMessageProcessor(topicExpression);
    }

    public void setTopicExpressionString(String topicExpression) {
        Assert.hasText((String)topicExpression, (String)"'topicExpression' must not be null or empty");
        this.topicProcessor = new ExpressionEvaluatingMessageProcessor(topicExpression);
    }

    protected MessageProcessor<String> getTopicProcessor() {
        return this.topicProcessor;
    }

    public void setDefaultQos(int defaultQos) {
        this.defaultQos = defaultQos;
    }

    protected int getDefaultQos() {
        return this.defaultQos;
    }

    public void setQosExpression(Expression qosExpression) {
        Assert.notNull((Object)qosExpression, (String)"'qosExpression' cannot be null");
        this.qosProcessor = new ExpressionEvaluatingMessageProcessor(qosExpression);
    }

    public void setQosExpressionString(String qosExpression) {
        Assert.hasText((String)qosExpression, (String)"'qosExpression' must not be null or empty");
        this.qosProcessor = new ExpressionEvaluatingMessageProcessor(qosExpression);
    }

    protected MessageProcessor<Integer> getQosProcessor() {
        return this.qosProcessor;
    }

    public void setDefaultRetained(boolean defaultRetained) {
        this.defaultRetained = defaultRetained;
    }

    protected boolean getDefaultRetained() {
        return this.defaultRetained;
    }

    public void setRetainedExpression(Expression retainedExpression) {
        Assert.notNull((Object)retainedExpression, (String)"'qosExpression' cannot be null");
        this.retainedProcessor = new ExpressionEvaluatingMessageProcessor(retainedExpression);
    }

    public void setRetainedExpressionString(String retainedExpression) {
        Assert.hasText((String)retainedExpression, (String)"'qosExpression' must not be null or empty");
        this.retainedProcessor = new ExpressionEvaluatingMessageProcessor(retainedExpression);
    }

    protected MessageProcessor<Boolean> getRetainedProcessor() {
        return this.retainedProcessor;
    }

    public void setConverter(MessageConverter converter) {
        Assert.notNull((Object)converter, (String)"'converter' cannot be null");
        this.converter = converter;
    }

    protected MessageConverter getConverter() {
        return this.converter;
    }

    @Nullable
    protected String getUrl() {
        return this.url;
    }

    @Nullable
    public String getClientId() {
        return this.clientId;
    }

    public int getClientInstance() {
        return this.clientInstance;
    }

    public String getComponentType() {
        return "mqtt:outbound-channel-adapter";
    }

    protected void incrementClientInstance() {
        ++this.clientInstance;
    }

    public void setCompletionTimeout(long completionTimeout) {
        this.completionTimeout = completionTimeout;
    }

    protected long getCompletionTimeout() {
        return this.completionTimeout;
    }

    public void setDisconnectCompletionTimeout(long completionTimeout) {
        this.disconnectCompletionTimeout = completionTimeout;
    }

    protected long getDisconnectCompletionTimeout() {
        return this.disconnectCompletionTimeout;
    }

    @Nullable
    protected ClientManager<T, C> getClientManager() {
        return this.clientManager;
    }

    protected void onInit() {
        super.onInit();
        if (this.topicProcessor instanceof BeanFactoryAware && this.getBeanFactory() != null) {
            ((BeanFactoryAware)this.topicProcessor).setBeanFactory(this.getBeanFactory());
        }
        if (this.qosProcessor instanceof BeanFactoryAware && this.getBeanFactory() != null) {
            ((BeanFactoryAware)this.qosProcessor).setBeanFactory(this.getBeanFactory());
        }
        if (this.retainedProcessor instanceof BeanFactoryAware && this.getBeanFactory() != null) {
            ((BeanFactoryAware)this.retainedProcessor).setBeanFactory(this.getBeanFactory());
        }
    }

    public final void start() {
        if (!this.running.getAndSet(true)) {
            this.doStart();
        }
    }

    protected abstract void doStart();

    public final void stop() {
        if (this.running.getAndSet(false)) {
            this.doStop();
        }
    }

    protected abstract void doStop();

    public boolean isRunning() {
        return this.running.get();
    }

    protected void handleMessageInternal(Message<?> message) {
        Object mqttMessage = this.converter.fromMessage(message, Object.class);
        String topic = (String)this.topicProcessor.processMessage(message);
        if (topic == null && this.defaultTopic == null) {
            throw new IllegalStateException("No topic could be determined from the message and no default topic defined");
        }
        this.publish(topic == null ? this.defaultTopic : topic, mqttMessage, message);
    }

    protected abstract void publish(String var1, Object var2, Message<?> var3);
}

