/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mqtt.inbound;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.log.LogMessage;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.mqtt.core.ClientManager;
import org.springframework.integration.mqtt.support.MqttMessageConverter;
import org.springframework.integration.support.management.IntegrationManagedResource;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.lang.Nullable;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;

@ManagedResource
@IntegrationManagedResource
public abstract class AbstractMqttMessageDrivenChannelAdapter<T, C>
extends MessageProducerSupport
implements ApplicationEventPublisherAware,
ClientManager.ConnectCallback {
    @Deprecated(since="6.0.3", forRemoval=true)
    public static final long DEFAULT_COMPLETION_TIMEOUT = 30000L;
    @Deprecated(since="6.0.3", forRemoval=true)
    public static final long DISCONNECT_COMPLETION_TIMEOUT = 5000L;
    protected final Lock topicLock = new ReentrantLock();
    private final String url;
    private final String clientId;
    private final Map<String, Integer> topics;
    private final ClientManager<T, C> clientManager;
    private long completionTimeout = 30000L;
    private long disconnectCompletionTimeout = 5000L;
    private boolean manualAcks;
    private ApplicationEventPublisher applicationEventPublisher;
    private MqttMessageConverter converter;

    public AbstractMqttMessageDrivenChannelAdapter(@Nullable String url, String clientId, String ... topic) {
        Assert.hasText((String)clientId, (String)"'clientId' cannot be null or empty");
        this.url = url;
        this.clientId = clientId;
        this.topics = AbstractMqttMessageDrivenChannelAdapter.initTopics(topic);
        this.clientManager = null;
    }

    public AbstractMqttMessageDrivenChannelAdapter(ClientManager<T, C> clientManager, String ... topic) {
        Assert.notNull(clientManager, (String)"'clientManager' cannot be null");
        this.clientManager = clientManager;
        this.topics = AbstractMqttMessageDrivenChannelAdapter.initTopics(topic);
        this.url = null;
        this.clientId = null;
    }

    private static Map<String, Integer> initTopics(String[] topics) {
        AbstractMqttMessageDrivenChannelAdapter.validateTopics(topics);
        return Arrays.stream(topics).collect(Collectors.toMap(Function.identity(), key -> 1, (x, y) -> y, LinkedHashMap::new));
    }

    private static void validateTopics(String[] topics) {
        Assert.notNull((Object)topics, (String)"'topics' cannot be null");
        Assert.noNullElements((Object[])topics, (String)"'topics' cannot have null elements");
        for (String topic : topics) {
            Assert.hasText((String)topic, (String)"The topic to subscribe cannot be empty string");
        }
    }

    public void setConverter(MqttMessageConverter converter) {
        Assert.notNull((Object)converter, (String)"'converter' cannot be null");
        this.converter = converter;
    }

    @Nullable
    protected ClientManager<T, C> getClientManager() {
        return this.clientManager;
    }

    public void setQos(int ... qos) {
        Assert.notNull((Object)qos, (String)"'qos' cannot be null");
        if (qos.length == 1) {
            for (Map.Entry<String, Integer> topic : this.topics.entrySet()) {
                topic.setValue(qos[0]);
            }
        } else {
            Assert.isTrue((qos.length == this.topics.size() ? 1 : 0) != 0, (String)"When setting qos, the array must be the same length as the topics");
            int n = 0;
            for (Map.Entry<String, Integer> topic : this.topics.entrySet()) {
                topic.setValue(qos[n++]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedAttribute
    public int[] getQos() {
        this.topicLock.lock();
        try {
            int[] topicQos = new int[this.topics.size()];
            int n = 0;
            Object object = this.topics.values().iterator();
            while (object.hasNext()) {
                int qos = object.next();
                topicQos[n++] = qos;
            }
            object = topicQos;
            return object;
        }
        finally {
            this.topicLock.unlock();
        }
    }

    @Nullable
    protected String getUrl() {
        return this.url;
    }

    @Nullable
    protected String getClientId() {
        return this.clientId;
    }

    protected MqttMessageConverter getConverter() {
        return this.converter;
    }

    @ManagedAttribute
    public String[] getTopic() {
        this.topicLock.lock();
        try {
            String[] stringArray = this.topics.keySet().toArray(new String[0]);
            return stringArray;
        }
        finally {
            this.topicLock.unlock();
        }
    }

    public void setDisconnectCompletionTimeout(long completionTimeout) {
        this.disconnectCompletionTimeout = completionTimeout;
    }

    protected long getDisconnectCompletionTimeout() {
        return this.disconnectCompletionTimeout;
    }

    protected void onInit() {
        super.onInit();
        if (this.clientManager != null) {
            this.clientManager.addCallback(this);
        }
    }

    public void destroy() {
        super.destroy();
        if (this.clientManager != null) {
            this.clientManager.removeCallback(this);
        }
    }

    public String getComponentType() {
        return "mqtt:inbound-channel-adapter";
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    protected ApplicationEventPublisher getApplicationEventPublisher() {
        return this.applicationEventPublisher;
    }

    public void setManualAcks(boolean manualAcks) {
        this.manualAcks = manualAcks;
    }

    protected boolean isManualAcks() {
        return this.clientManager == null ? this.manualAcks : this.clientManager.isManualAcks();
    }

    public void setCompletionTimeout(long completionTimeout) {
        this.completionTimeout = completionTimeout;
    }

    protected long getCompletionTimeout() {
        return this.completionTimeout;
    }

    @ManagedOperation
    public void addTopic(String topic, int qos) {
        AbstractMqttMessageDrivenChannelAdapter.validateTopics(new String[]{topic});
        this.topicLock.lock();
        try {
            if (this.topics.containsKey(topic)) {
                throw new MessagingException("Topic '" + topic + "' is already subscribed.");
            }
            this.topics.put(topic, qos);
            this.logger.debug((CharSequence)LogMessage.format((String)"Added '%s' to subscriptions.", (Object)topic));
        }
        finally {
            this.topicLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation
    public void addTopic(String ... topics) {
        AbstractMqttMessageDrivenChannelAdapter.validateTopics(topics);
        this.topicLock.lock();
        try {
            for (String t : topics) {
                this.addTopic(t, 1);
            }
        }
        finally {
            this.topicLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation
    public void addTopics(String[] topics, int[] qos) {
        AbstractMqttMessageDrivenChannelAdapter.validateTopics(topics);
        Assert.isTrue((topics.length == qos.length ? 1 : 0) != 0, (String)"topics and qos arrays must the be the same length.");
        this.topicLock.lock();
        try {
            for (String newTopic : topics) {
                if (!this.topics.containsKey(newTopic)) continue;
                throw new MessagingException("Topic '" + newTopic + "' is already subscribed.");
            }
            for (int i = 0; i < topics.length; ++i) {
                this.addTopic(topics[i], qos[i]);
            }
        }
        finally {
            this.topicLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation
    public void removeTopic(String ... topic) {
        this.topicLock.lock();
        try {
            for (String name : topic) {
                if (this.topics.remove(name) == null) continue;
                this.logger.debug((CharSequence)LogMessage.format((String)"Removed '%s' from subscriptions.", (Object)name));
            }
        }
        finally {
            this.topicLock.unlock();
        }
    }
}

