/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mqtt.outbound;

import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.integration.mqtt.core.ClientManager;
import org.springframework.integration.mqtt.core.DefaultMqttPahoClientFactory;
import org.springframework.integration.mqtt.core.MqttPahoClientFactory;
import org.springframework.integration.mqtt.core.MqttPahoComponent;
import org.springframework.integration.mqtt.event.MqttConnectionFailedEvent;
import org.springframework.integration.mqtt.outbound.AbstractMqttMessageHandler;
import org.springframework.integration.mqtt.support.DefaultPahoMessageConverter;
import org.springframework.integration.mqtt.support.MqttMessageConverter;
import org.springframework.integration.mqtt.support.MqttUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.Assert;

public class MqttPahoMessageHandler
extends AbstractMqttMessageHandler<IMqttAsyncClient, MqttConnectOptions>
implements MqttCallback,
MqttPahoComponent {
    private final MqttPahoClientFactory clientFactory;
    private final IMqttActionListener mqttPublishActionListener = new MqttPublishActionListener();
    private volatile IMqttAsyncClient client;

    public MqttPahoMessageHandler(String url, String clientId) {
        this(url, clientId, new DefaultMqttPahoClientFactory());
    }

    public MqttPahoMessageHandler(String url, String clientId, MqttPahoClientFactory clientFactory) {
        super(url, clientId);
        this.clientFactory = clientFactory;
    }

    public MqttPahoMessageHandler(String clientId, MqttPahoClientFactory clientFactory) {
        super(null, clientId);
        this.clientFactory = clientFactory;
    }

    public MqttPahoMessageHandler(ClientManager<IMqttAsyncClient, MqttConnectOptions> clientManager) {
        super(clientManager);
        DefaultMqttPahoClientFactory factory = new DefaultMqttPahoClientFactory();
        factory.setConnectionOptions((MqttConnectOptions)clientManager.getConnectionInfo());
        this.clientFactory = factory;
    }

    @Override
    public MqttConnectOptions getConnectionInfo() {
        String url;
        MqttConnectOptions options = this.clientFactory.getConnectionOptions();
        if (options.getServerURIs() == null && (url = this.getUrl()) != null) {
            options = MqttUtils.cloneConnectOptions(options);
            options.setServerURIs(new String[]{url});
        }
        return options;
    }

    @Override
    protected void onInit() {
        super.onInit();
        MessageConverter converter = this.getConverter();
        if (converter == null) {
            DefaultPahoMessageConverter defaultConverter = new DefaultPahoMessageConverter(this.getDefaultQos(), this.getQosProcessor(), this.getDefaultRetained(), this.getRetainedProcessor());
            if (this.getBeanFactory() != null) {
                defaultConverter.setBeanFactory(this.getBeanFactory());
            }
            this.setConverter(defaultConverter);
        } else {
            Assert.state((boolean)(converter instanceof MqttMessageConverter), (String)"MessageConverter must be an MqttMessageConverter");
        }
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
        try {
            IMqttAsyncClient theClient = this.client;
            if (theClient != null) {
                theClient.disconnect().waitForCompletion(this.getDisconnectCompletionTimeout());
                if (this.getConnectionInfo().isAutomaticReconnect()) {
                    MqttUtils.stopClientReconnectCycle(theClient);
                }
                theClient.close();
                this.client = null;
            }
        }
        catch (MqttException ex) {
            this.logger.error((Throwable)ex, (CharSequence)"Failed to disconnect");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IMqttAsyncClient checkConnection() throws MqttException {
        this.lock.lock();
        try {
            ClientManager theClientManager = this.getClientManager();
            if (theClientManager != null) {
                IMqttAsyncClient iMqttAsyncClient = (IMqttAsyncClient)theClientManager.getClient();
                return iMqttAsyncClient;
            }
            if (this.client != null && !this.client.isConnected()) {
                this.client.setCallback(null);
                this.client.close();
                this.client = null;
            }
            if (this.client == null) {
                try {
                    MqttConnectOptions connectionOptions = this.clientFactory.getConnectionOptions();
                    Assert.state((this.getUrl() != null || connectionOptions.getServerURIs() != null ? 1 : 0) != 0, (String)"If no 'url' provided, connectionOptions.getServerURIs() must not be null");
                    this.client = this.clientFactory.getAsyncClientInstance(this.getUrl(), this.getClientId());
                    this.incrementClientInstance();
                    this.client.setCallback((MqttCallback)this);
                    this.client.connect(connectionOptions).waitForCompletion(this.getCompletionTimeout());
                    this.logger.debug((CharSequence)"Client connected");
                }
                catch (MqttException e) {
                    ApplicationEventPublisher applicationEventPublisher;
                    if (this.client != null) {
                        this.client.close();
                        this.client = null;
                    }
                    if ((applicationEventPublisher = this.getApplicationEventPublisher()) != null) {
                        applicationEventPublisher.publishEvent((ApplicationEvent)new MqttConnectionFailedEvent(this, e));
                    }
                    throw new MessagingException("Failed to connect", (Throwable)e);
                }
            }
            IMqttAsyncClient iMqttAsyncClient = this.client;
            return iMqttAsyncClient;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected void publish(String topic, Object mqttMessage, Message<?> message) {
        Assert.isInstanceOf(MqttMessage.class, (Object)mqttMessage, (String)"The 'mqttMessage' must be an instance of 'MqttMessage'");
        try {
            IMqttDeliveryToken token = this.checkConnection().publish(topic, (MqttMessage)mqttMessage, null, this.mqttPublishActionListener);
            if (!this.isAsync()) {
                token.waitForCompletion(this.getCompletionTimeout());
            } else {
                this.messageSentEvent(message, topic, token.getMessageId());
            }
        }
        catch (MqttException e) {
            throw new MessageHandlingException(message, "Failed to publish to MQTT in the [" + this + "]", (Throwable)e);
        }
    }

    public void connectionLost(Throwable cause) {
        block6: {
            this.lock.lock();
            try {
                this.logger.error((CharSequence)"Lost connection; will attempt reconnect on next request");
                if (this.client == null) break block6;
                try {
                    this.client.setCallback(null);
                    this.client.close();
                }
                catch (MqttException mqttException) {
                    // empty catch block
                }
                this.client = null;
                ApplicationEventPublisher applicationEventPublisher = this.getApplicationEventPublisher();
                if (applicationEventPublisher != null) {
                    applicationEventPublisher.publishEvent((ApplicationEvent)new MqttConnectionFailedEvent(this, cause));
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void messageArrived(String topic, MqttMessage message) {
    }

    public void deliveryComplete(IMqttDeliveryToken token) {
    }

    private final class MqttPublishActionListener
    implements IMqttActionListener {
        MqttPublishActionListener() {
        }

        public void onSuccess(IMqttToken asyncActionToken) {
            MqttPahoMessageHandler.this.sendDeliveryCompleteEvent(asyncActionToken.getMessageId());
        }

        public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
            MqttPahoMessageHandler.this.sendFailedDeliveryEvent(asyncActionToken.getMessageId(), exception);
        }
    }
}

