/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.scripting.config;

import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.scripting.support.StaticScriptSource;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public abstract class AbstractScriptParser
extends AbstractSingleBeanDefinitionParser {
    protected static final String LOCATION_ATTRIBUTE = "location";
    protected static final String REFRESH_CHECK_DELAY_ATTRIBUTE = "refresh-check-delay";

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected abstract String getBeanClassName(Element var1);

    protected abstract String getScriptSourceClassName();

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String scriptLocation = element.getAttribute(LOCATION_ATTRIBUTE);
        String scriptText = DomUtils.getTextValue((Element)element);
        if (!(StringUtils.hasText((String)scriptLocation) ^ StringUtils.hasText((String)scriptText))) {
            parserContext.getReaderContext().error("Either the 'location' attribute or inline script text must be provided, but not both.", (Object)element);
            return;
        }
        List variableElements = DomUtils.getChildElementsByTagName((Element)element, (String)"variable");
        String scriptVariableGeneratorName = element.getAttribute("script-variable-generator");
        if (StringUtils.hasText((String)scriptText) && (variableElements.size() > 0 || StringUtils.hasText((String)scriptVariableGeneratorName))) {
            parserContext.getReaderContext().error("Variable bindings or custom ScriptVariableGenerator are not allowed when using an inline groovy script. Specify location of the script via 'location' attribute instead", (Object)element);
            return;
        }
        if (StringUtils.hasText((String)scriptVariableGeneratorName) && variableElements.size() > 0) {
            parserContext.getReaderContext().error("'script-variable-generator' and 'variable' sub-elements are mutually exclusive.", (Object)element);
            return;
        }
        if (StringUtils.hasText((String)scriptLocation)) {
            builder.addConstructorArgValue(this.resolveScriptLocation(element, parserContext.getReaderContext(), scriptLocation));
        } else if (this.getScriptSourceClassName() != null) {
            builder.addConstructorArgValue((Object)new StaticScriptSource(scriptText, this.getScriptSourceClassName()));
        } else {
            builder.addConstructorArgValue((Object)new StaticScriptSource(scriptText));
        }
        if (!StringUtils.hasText((String)scriptVariableGeneratorName)) {
            BeanDefinitionBuilder scriptVariableGeneratorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.scripting.DefaultScriptVariableGenerator");
            ManagedMap variableMap = new ManagedMap();
            for (Element childElement : variableElements) {
                String variableName = childElement.getAttribute("name");
                String variableValue = childElement.getAttribute("value");
                String variableRef = childElement.getAttribute("ref");
                if (!(StringUtils.hasText((String)variableValue) ^ StringUtils.hasText((String)variableRef))) {
                    parserContext.getReaderContext().error("Exactly one of the 'ref' attribute or 'value' attribute,  is required for element " + IntegrationNamespaceUtils.createElementDescription((Element)element) + ".", (Object)element);
                }
                if (StringUtils.hasText((String)variableValue)) {
                    variableMap.put((Object)variableName, (Object)variableValue);
                    continue;
                }
                variableMap.put((Object)variableName, (Object)new RuntimeBeanReference(variableRef));
            }
            if (!CollectionUtils.isEmpty((Map)variableMap)) {
                scriptVariableGeneratorBuilder.addConstructorArgValue((Object)variableMap);
            }
            scriptVariableGeneratorName = BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)scriptVariableGeneratorBuilder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
        }
        builder.addConstructorArgReference(scriptVariableGeneratorName);
        this.postProcess(builder, element, parserContext);
    }

    protected void postProcess(BeanDefinitionBuilder builder, Element element, ParserContext parserContext) {
    }

    private Object resolveScriptLocation(Element element, XmlReaderContext readerContext, String scriptLocation) {
        String refreshDelayText = element.getAttribute(REFRESH_CHECK_DELAY_ATTRIBUTE);
        String beanClassName = "org.springframework.integration.scripting.RefreshableResourceScriptSource";
        BeanDefinitionBuilder resourceScriptSourceBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)beanClassName);
        resourceScriptSourceBuilder.addConstructorArgValue((Object)scriptLocation);
        if (StringUtils.hasText((String)refreshDelayText)) {
            resourceScriptSourceBuilder.addConstructorArgValue((Object)refreshDelayText);
        } else {
            resourceScriptSourceBuilder.addConstructorArgValue((Object)-1L);
        }
        return resourceScriptSourceBuilder.getBeanDefinition();
    }
}

