/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.scripting.jsr223;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.springframework.integration.scripting.PolyglotScriptExecutor;
import org.springframework.integration.scripting.ScriptExecutor;
import org.springframework.integration.scripting.jsr223.DefaultScriptExecutor;
import org.springframework.integration.scripting.jsr223.KotlinScriptExecutor;
import org.springframework.integration.scripting.jsr223.PythonScriptExecutor;
import org.springframework.integration.scripting.jsr223.RubyScriptExecutor;
import org.springframework.util.Assert;

public final class ScriptExecutorFactory {
    public static ScriptExecutor getScriptExecutor(String language) {
        if (language.equalsIgnoreCase("python") || language.equalsIgnoreCase("jython")) {
            return new PythonScriptExecutor();
        }
        if (language.equalsIgnoreCase("ruby") || language.equalsIgnoreCase("jruby")) {
            return new RubyScriptExecutor();
        }
        if (language.equalsIgnoreCase("kotlin")) {
            return new KotlinScriptExecutor();
        }
        if (language.equalsIgnoreCase("js") || language.equalsIgnoreCase("javascript")) {
            return new PolyglotScriptExecutor("js");
        }
        return new DefaultScriptExecutor(language);
    }

    public static String deriveLanguageFromFileExtension(String scriptLocation) {
        int index = scriptLocation.lastIndexOf(46) + 1;
        Assert.state((index > 0 ? 1 : 0) != 0, () -> "Unable to determine language for script '" + scriptLocation + "'");
        String extension = scriptLocation.substring(index);
        if (extension.equals("kts")) {
            return "kotlin";
        }
        if (extension.equals("js")) {
            return "js";
        }
        ScriptEngineManager engineManager = new ScriptEngineManager();
        ScriptEngine engine = engineManager.getEngineByExtension(extension);
        Assert.state((engine != null ? 1 : 0) != 0, () -> "No suitable scripting engine found for extension '" + extension + "'");
        return engine.getFactory().getLanguageName();
    }

    private ScriptExecutorFactory() {
    }
}

